@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.AutoscaleNotificationResponse
import com.pulumi.azurenative.insights.kotlin.outputs.AutoscaleProfileResponse
import com.pulumi.azurenative.insights.kotlin.outputs.PredictiveAutoscalePolicyResponse
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.AutoscaleNotificationResponse.Companion.toKotlin as autoscaleNotificationResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.AutoscaleProfileResponse.Companion.toKotlin as autoscaleProfileResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.PredictiveAutoscalePolicyResponse.Companion.toKotlin as predictiveAutoscalePolicyResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AutoscaleSetting].
 */
@PulumiTagMarker
public class AutoscaleSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutoscaleSettingArgs = AutoscaleSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutoscaleSettingArgsBuilder.() -> Unit) {
        val builder = AutoscaleSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AutoscaleSetting {
        val builtJavaResource =
            com.pulumi.azurenative.insights.AutoscaleSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AutoscaleSetting(builtJavaResource)
    }
}

/**
 * The autoscale setting resource.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2015-04-01.
 * ## Example Usage
 * ### Create or update an autoscale setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var autoscaleSetting = new AzureNative.Insights.AutoscaleSetting("autoscaleSetting", new()
 *     {
 *         AutoscaleSettingName = "MySetting",
 *         Enabled = true,
 *         Location = "West US",
 *         Notifications = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AutoscaleNotificationArgs
 *             {
 *                 Email = new AzureNative.Insights.Inputs.EmailNotificationArgs
 *                 {
 *                     CustomEmails = new[]
 *                     {
 *                         "gu@ms.com",
 *                         "ge@ns.net",
 *                     },
 *                     SendToSubscriptionAdministrator = true,
 *                     SendToSubscriptionCoAdministrators = true,
 *                 },
 *                 Operation = AzureNative.Insights.OperationType.Scale,
 *                 Webhooks = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.WebhookNotificationArgs
 *                     {
 *                         Properties = null,
 *                         ServiceUri = "http://myservice.com",
 *                     },
 *                 },
 *             },
 *         },
 *         PredictiveAutoscalePolicy = new AzureNative.Insights.Inputs.PredictiveAutoscalePolicyArgs
 *         {
 *             ScaleMode = AzureNative.Insights.PredictiveAutoscalePolicyScaleMode.Enabled,
 *         },
 *         Profiles = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AutoscaleProfileArgs
 *             {
 *                 Capacity = new AzureNative.Insights.Inputs.ScaleCapacityArgs
 *                 {
 *                     Default = "1",
 *                     Maximum = "10",
 *                     Minimum = "1",
 *                 },
 *                 FixedDate = new AzureNative.Insights.Inputs.TimeWindowArgs
 *                 {
 *                     End = "2015-03-05T14:30:00Z",
 *                     Start = "2015-03-05T14:00:00Z",
 *                     TimeZone = "UTC",
 *                 },
 *                 Name = "adios",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.ScaleRuleArgs
 *                     {
 *                         MetricTrigger = new AzureNative.Insights.Inputs.MetricTriggerArgs
 *                         {
 *                             DividePerInstance = false,
 *                             MetricName = "Percentage CPU",
 *                             MetricResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
 *                             Operator = AzureNative.Insights.ComparisonOperationType.GreaterThan,
 *                             Statistic = AzureNative.Insights.MetricStatisticType.Average,
 *                             Threshold = 10,
 *                             TimeAggregation = AzureNative.Insights.TimeAggregationType.Average,
 *                             TimeGrain = "PT1M",
 *                             TimeWindow = "PT5M",
 *                         },
 *                         ScaleAction = new AzureNative.Insights.Inputs.ScaleActionArgs
 *                         {
 *                             Cooldown = "PT5M",
 *                             Direction = AzureNative.Insights.ScaleDirection.Increase,
 *                             Type = AzureNative.Insights.ScaleType.ChangeCount,
 *                             Value = "1",
 *                         },
 *                     },
 *                     new AzureNative.Insights.Inputs.ScaleRuleArgs
 *                     {
 *                         MetricTrigger = new AzureNative.Insights.Inputs.MetricTriggerArgs
 *                         {
 *                             DividePerInstance = false,
 *                             MetricName = "Percentage CPU",
 *                             MetricResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
 *                             Operator = AzureNative.Insights.ComparisonOperationType.GreaterThan,
 *                             Statistic = AzureNative.Insights.MetricStatisticType.Average,
 *                             Threshold = 15,
 *                             TimeAggregation = AzureNative.Insights.TimeAggregationType.Average,
 *                             TimeGrain = "PT2M",
 *                             TimeWindow = "PT5M",
 *                         },
 *                         ScaleAction = new AzureNative.Insights.Inputs.ScaleActionArgs
 *                         {
 *                             Cooldown = "PT6M",
 *                             Direction = AzureNative.Insights.ScaleDirection.Decrease,
 *                             Type = AzureNative.Insights.ScaleType.ChangeCount,
 *                             Value = "2",
 *                         },
 *                     },
 *                 },
 *             },
 *             new AzureNative.Insights.Inputs.AutoscaleProfileArgs
 *             {
 *                 Capacity = new AzureNative.Insights.Inputs.ScaleCapacityArgs
 *                 {
 *                     Default = "1",
 *                     Maximum = "10",
 *                     Minimum = "1",
 *                 },
 *                 Name = "saludos",
 *                 Recurrence = new AzureNative.Insights.Inputs.RecurrenceArgs
 *                 {
 *                     Frequency = AzureNative.Insights.RecurrenceFrequency.Week,
 *                     Schedule = new AzureNative.Insights.Inputs.RecurrentScheduleArgs
 *                     {
 *                         Days = new[]
 *                         {
 *                             "1",
 *                         },
 *                         Hours = new[]
 *                         {
 *                             5,
 *                         },
 *                         Minutes = new[]
 *                         {
 *                             15,
 *                         },
 *                         TimeZone = "UTC",
 *                     },
 *                 },
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.ScaleRuleArgs
 *                     {
 *                         MetricTrigger = new AzureNative.Insights.Inputs.MetricTriggerArgs
 *                         {
 *                             DividePerInstance = false,
 *                             MetricName = "Percentage CPU",
 *                             MetricResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
 *                             Operator = AzureNative.Insights.ComparisonOperationType.GreaterThan,
 *                             Statistic = AzureNative.Insights.MetricStatisticType.Average,
 *                             Threshold = 10,
 *                             TimeAggregation = AzureNative.Insights.TimeAggregationType.Average,
 *                             TimeGrain = "PT1M",
 *                             TimeWindow = "PT5M",
 *                         },
 *                         ScaleAction = new AzureNative.Insights.Inputs.ScaleActionArgs
 *                         {
 *                             Cooldown = "PT5M",
 *                             Direction = AzureNative.Insights.ScaleDirection.Increase,
 *                             Type = AzureNative.Insights.ScaleType.ChangeCount,
 *                             Value = "1",
 *                         },
 *                     },
 *                     new AzureNative.Insights.Inputs.ScaleRuleArgs
 *                     {
 *                         MetricTrigger = new AzureNative.Insights.Inputs.MetricTriggerArgs
 *                         {
 *                             DividePerInstance = false,
 *                             MetricName = "Percentage CPU",
 *                             MetricResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
 *                             Operator = AzureNative.Insights.ComparisonOperationType.GreaterThan,
 *                             Statistic = AzureNative.Insights.MetricStatisticType.Average,
 *                             Threshold = 15,
 *                             TimeAggregation = AzureNative.Insights.TimeAggregationType.Average,
 *                             TimeGrain = "PT2M",
 *                             TimeWindow = "PT5M",
 *                         },
 *                         ScaleAction = new AzureNative.Insights.Inputs.ScaleActionArgs
 *                         {
 *                             Cooldown = "PT6M",
 *                             Direction = AzureNative.Insights.ScaleDirection.Decrease,
 *                             Type = AzureNative.Insights.ScaleType.ChangeCount,
 *                             Value = "2",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "TestingMetricsScaleSet",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *         TargetResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewAutoscaleSetting(ctx, "autoscaleSetting", &insights.AutoscaleSettingArgs{
 * 			AutoscaleSettingName: pulumi.String("MySetting"),
 * 			Enabled:              pulumi.Bool(true),
 * 			Location:             pulumi.String("West US"),
 * 			Notifications: []insights.AutoscaleNotificationArgs{
 * 				{
 * 					Email: {
 * 						CustomEmails: pulumi.StringArray{
 * 							pulumi.String("gu@ms.com"),
 * 							pulumi.String("ge@ns.net"),
 * 						},
 * 						SendToSubscriptionAdministrator:    pulumi.Bool(true),
 * 						SendToSubscriptionCoAdministrators: pulumi.Bool(true),
 * 					},
 * 					Operation: insights.OperationTypeScale,
 * 					Webhooks: insights.WebhookNotificationArray{
 * 						{
 * 							Properties: nil,
 * 							ServiceUri: pulumi.String("http://myservice.com"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			PredictiveAutoscalePolicy: &insights.PredictiveAutoscalePolicyArgs{
 * 				ScaleMode: insights.PredictiveAutoscalePolicyScaleModeEnabled,
 * 			},
 * 			Profiles: []insights.AutoscaleProfileArgs{
 * 				{
 * 					Capacity: {
 * 						Default: pulumi.String("1"),
 * 						Maximum: pulumi.String("10"),
 * 						Minimum: pulumi.String("1"),
 * 					},
 * 					FixedDate: {
 * 						End:      pulumi.String("2015-03-05T14:30:00Z"),
 * 						Start:    pulumi.String("2015-03-05T14:00:00Z"),
 * 						TimeZone: pulumi.String("UTC"),
 * 					},
 * 					Name: pulumi.String("adios"),
 * 					Rules: insights.ScaleRuleArray{
 * 						{
 * 							MetricTrigger: {
 * 								DividePerInstance: pulumi.Bool(false),
 * 								MetricName:        pulumi.String("Percentage CPU"),
 * 								MetricResourceUri: pulumi.String("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 * 								Operator:          insights.ComparisonOperationTypeGreaterThan,
 * 								Statistic:         insights.MetricStatisticTypeAverage,
 * 								Threshold:         pulumi.Float64(10),
 * 								TimeAggregation:   insights.TimeAggregationTypeAverage,
 * 								TimeGrain:         pulumi.String("PT1M"),
 * 								TimeWindow:        pulumi.String("PT5M"),
 * 							},
 * 							ScaleAction: {
 * 								Cooldown:  pulumi.String("PT5M"),
 * 								Direction: insights.ScaleDirectionIncrease,
 * 								Type:      insights.ScaleTypeChangeCount,
 * 								Value:     pulumi.String("1"),
 * 							},
 * 						},
 * 						{
 * 							MetricTrigger: {
 * 								DividePerInstance: pulumi.Bool(false),
 * 								MetricName:        pulumi.String("Percentage CPU"),
 * 								MetricResourceUri: pulumi.String("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 * 								Operator:          insights.ComparisonOperationTypeGreaterThan,
 * 								Statistic:         insights.MetricStatisticTypeAverage,
 * 								Threshold:         pulumi.Float64(15),
 * 								TimeAggregation:   insights.TimeAggregationTypeAverage,
 * 								TimeGrain:         pulumi.String("PT2M"),
 * 								TimeWindow:        pulumi.String("PT5M"),
 * 							},
 * 							ScaleAction: {
 * 								Cooldown:  pulumi.String("PT6M"),
 * 								Direction: insights.ScaleDirectionDecrease,
 * 								Type:      insights.ScaleTypeChangeCount,
 * 								Value:     pulumi.String("2"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				{
 * 					Capacity: {
 * 						Default: pulumi.String("1"),
 * 						Maximum: pulumi.String("10"),
 * 						Minimum: pulumi.String("1"),
 * 					},
 * 					Name: pulumi.String("saludos"),
 * 					Recurrence: {
 * 						Frequency: insights.RecurrenceFrequencyWeek,
 * 						Schedule: {
 * 							Days: pulumi.StringArray{
 * 								pulumi.String("1"),
 * 							},
 * 							Hours: pulumi.IntArray{
 * 								pulumi.Int(5),
 * 							},
 * 							Minutes: pulumi.IntArray{
 * 								pulumi.Int(15),
 * 							},
 * 							TimeZone: pulumi.String("UTC"),
 * 						},
 * 					},
 * 					Rules: insights.ScaleRuleArray{
 * 						{
 * 							MetricTrigger: {
 * 								DividePerInstance: pulumi.Bool(false),
 * 								MetricName:        pulumi.String("Percentage CPU"),
 * 								MetricResourceUri: pulumi.String("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 * 								Operator:          insights.ComparisonOperationTypeGreaterThan,
 * 								Statistic:         insights.MetricStatisticTypeAverage,
 * 								Threshold:         pulumi.Float64(10),
 * 								TimeAggregation:   insights.TimeAggregationTypeAverage,
 * 								TimeGrain:         pulumi.String("PT1M"),
 * 								TimeWindow:        pulumi.String("PT5M"),
 * 							},
 * 							ScaleAction: {
 * 								Cooldown:  pulumi.String("PT5M"),
 * 								Direction: insights.ScaleDirectionIncrease,
 * 								Type:      insights.ScaleTypeChangeCount,
 * 								Value:     pulumi.String("1"),
 * 							},
 * 						},
 * 						{
 * 							MetricTrigger: {
 * 								DividePerInstance: pulumi.Bool(false),
 * 								MetricName:        pulumi.String("Percentage CPU"),
 * 								MetricResourceUri: pulumi.String("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 * 								Operator:          insights.ComparisonOperationTypeGreaterThan,
 * 								Statistic:         insights.MetricStatisticTypeAverage,
 * 								Threshold:         pulumi.Float64(15),
 * 								TimeAggregation:   insights.TimeAggregationTypeAverage,
 * 								TimeGrain:         pulumi.String("PT2M"),
 * 								TimeWindow:        pulumi.String("PT5M"),
 * 							},
 * 							ScaleAction: {
 * 								Cooldown:  pulumi.String("PT6M"),
 * 								Direction: insights.ScaleDirectionDecrease,
 * 								Type:      insights.ScaleTypeChangeCount,
 * 								Value:     pulumi.String("2"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("TestingMetricsScaleSet"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 			TargetResourceUri: pulumi.String("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.AutoscaleSetting;
 * import com.pulumi.azurenative.insights.AutoscaleSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var autoscaleSetting = new AutoscaleSetting("autoscaleSetting", AutoscaleSettingArgs.builder()
 *             .autoscaleSettingName("MySetting")
 *             .enabled(true)
 *             .location("West US")
 *             .notifications(Map.ofEntries(
 *                 Map.entry("email", Map.ofEntries(
 *                     Map.entry("customEmails",
 *                         "gu@ms.com",
 *                         "ge@ns.net"),
 *                     Map.entry("sendToSubscriptionAdministrator", true),
 *                     Map.entry("sendToSubscriptionCoAdministrators", true)
 *                 )),
 *                 Map.entry("operation", "Scale"),
 *                 Map.entry("webhooks", Map.ofEntries(
 *                     Map.entry("properties", ),
 *                     Map.entry("serviceUri", "http://myservice.com")
 *                 ))
 *             ))
 *             .predictiveAutoscalePolicy(Map.of("scaleMode", "Enabled"))
 *             .profiles(
 *                 Map.ofEntries(
 *                     Map.entry("capacity", Map.ofEntries(
 *                         Map.entry("default", "1"),
 *                         Map.entry("maximum", "10"),
 *                         Map.entry("minimum", "1")
 *                     )),
 *                     Map.entry("fixedDate", Map.ofEntries(
 *                         Map.entry("end", "2015-03-05T14:30:00Z"),
 *                         Map.entry("start", "2015-03-05T14:00:00Z"),
 *                         Map.entry("timeZone", "UTC")
 *                     )),
 *                     Map.entry("name", "adios"),
 *                     Map.entry("rules",
 *                         Map.ofEntries(
 *                             Map.entry("metricTrigger", Map.ofEntries(
 *                                 Map.entry("dividePerInstance", false),
 *                                 Map.entry("metricName", "Percentage CPU"),
 *                                 Map.entry("metricResourceUri", "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 *                                 Map.entry("operator", "GreaterThan"),
 *                                 Map.entry("statistic", "Average"),
 *                                 Map.entry("threshold", 10),
 *                                 Map.entry("timeAggregation", "Average"),
 *                                 Map.entry("timeGrain", "PT1M"),
 *                                 Map.entry("timeWindow", "PT5M")
 *                             )),
 *                             Map.entry("scaleAction", Map.ofEntries(
 *                                 Map.entry("cooldown", "PT5M"),
 *                                 Map.entry("direction", "Increase"),
 *                                 Map.entry("type", "ChangeCount"),
 *                                 Map.entry("value", "1")
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("metricTrigger", Map.ofEntries(
 *                                 Map.entry("dividePerInstance", false),
 *                                 Map.entry("metricName", "Percentage CPU"),
 *                                 Map.entry("metricResourceUri", "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 *                                 Map.entry("operator", "GreaterThan"),
 *                                 Map.entry("statistic", "Average"),
 *                                 Map.entry("threshold", 15),
 *                                 Map.entry("timeAggregation", "Average"),
 *                                 Map.entry("timeGrain", "PT2M"),
 *                                 Map.entry("timeWindow", "PT5M")
 *                             )),
 *                             Map.entry("scaleAction", Map.ofEntries(
 *                                 Map.entry("cooldown", "PT6M"),
 *                                 Map.entry("direction", "Decrease"),
 *                                 Map.entry("type", "ChangeCount"),
 *                                 Map.entry("value", "2")
 *                             ))
 *                         ))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("capacity", Map.ofEntries(
 *                         Map.entry("default", "1"),
 *                         Map.entry("maximum", "10"),
 *                         Map.entry("minimum", "1")
 *                     )),
 *                     Map.entry("name", "saludos"),
 *                     Map.entry("recurrence", Map.ofEntries(
 *                         Map.entry("frequency", "Week"),
 *                         Map.entry("schedule", Map.ofEntries(
 *                             Map.entry("days", "1"),
 *                             Map.entry("hours", 5),
 *                             Map.entry("minutes", 15),
 *                             Map.entry("timeZone", "UTC")
 *                         ))
 *                     )),
 *                     Map.entry("rules",
 *                         Map.ofEntries(
 *                             Map.entry("metricTrigger", Map.ofEntries(
 *                                 Map.entry("dividePerInstance", false),
 *                                 Map.entry("metricName", "Percentage CPU"),
 *                                 Map.entry("metricResourceUri", "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 *                                 Map.entry("operator", "GreaterThan"),
 *                                 Map.entry("statistic", "Average"),
 *                                 Map.entry("threshold", 10),
 *                                 Map.entry("timeAggregation", "Average"),
 *                                 Map.entry("timeGrain", "PT1M"),
 *                                 Map.entry("timeWindow", "PT5M")
 *                             )),
 *                             Map.entry("scaleAction", Map.ofEntries(
 *                                 Map.entry("cooldown", "PT5M"),
 *                                 Map.entry("direction", "Increase"),
 *                                 Map.entry("type", "ChangeCount"),
 *                                 Map.entry("value", "1")
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("metricTrigger", Map.ofEntries(
 *                                 Map.entry("dividePerInstance", false),
 *                                 Map.entry("metricName", "Percentage CPU"),
 *                                 Map.entry("metricResourceUri", "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 *                                 Map.entry("operator", "GreaterThan"),
 *                                 Map.entry("statistic", "Average"),
 *                                 Map.entry("threshold", 15),
 *                                 Map.entry("timeAggregation", "Average"),
 *                                 Map.entry("timeGrain", "PT2M"),
 *                                 Map.entry("timeWindow", "PT5M")
 *                             )),
 *                             Map.entry("scaleAction", Map.ofEntries(
 *                                 Map.entry("cooldown", "PT6M"),
 *                                 Map.entry("direction", "Decrease"),
 *                                 Map.entry("type", "ChangeCount"),
 *                                 Map.entry("value", "2")
 *                             ))
 *                         ))
 *                 ))
 *             .resourceGroupName("TestingMetricsScaleSet")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .targetResourceUri("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:AutoscaleSetting MySetting /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Insights/autoscalesettings/{autoscaleSettingName}
 * ```
 */
public class AutoscaleSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.AutoscaleSetting,
) : KotlinCustomResource(javaResource, AutoscaleSettingMapper) {
    /**
     * the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * the collection of notifications.
     */
    public val notifications: Output<List<AutoscaleNotificationResponse>>?
        get() = javaResource.notifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        autoscaleNotificationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * the predictive autoscale policy mode.
     */
    public val predictiveAutoscalePolicy: Output<PredictiveAutoscalePolicyResponse>?
        get() = javaResource.predictiveAutoscalePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> predictiveAutoscalePolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
     */
    public val profiles: Output<List<AutoscaleProfileResponse>>
        get() = javaResource.profiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    autoscaleProfileResponseToKotlin(args0)
                })
            })
        })

    /**
     * The system metadata related to the response.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * the location of the resource that the autoscale setting should be added to.
     */
    public val targetResourceLocation: Output<String>?
        get() = javaResource.targetResourceLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the resource identifier of the resource that the autoscale setting should be added to.
     */
    public val targetResourceUri: Output<String>?
        get() = javaResource.targetResourceUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AutoscaleSettingMapper : ResourceMapper<AutoscaleSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.AutoscaleSetting::class == javaResource::class

    override fun map(javaResource: Resource): AutoscaleSetting = AutoscaleSetting(
        javaResource as
            com.pulumi.azurenative.insights.AutoscaleSetting,
    )
}

/**
 * @see [AutoscaleSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutoscaleSetting].
 */
public suspend fun autoscaleSetting(
    name: String,
    block: suspend AutoscaleSettingResourceBuilder.() -> Unit,
): AutoscaleSetting {
    val builder = AutoscaleSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutoscaleSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun autoscaleSetting(name: String): AutoscaleSetting {
    val builder = AutoscaleSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
