@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.AutoscaleSettingArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.AutoscaleNotificationArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AutoscaleNotificationArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.AutoscaleProfileArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AutoscaleProfileArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.PredictiveAutoscalePolicyArgs
import com.pulumi.azurenative.insights.kotlin.inputs.PredictiveAutoscalePolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The autoscale setting resource.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2015-04-01.
 * ## Example Usage
 * ### Create or update an autoscale setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var autoscaleSetting = new AzureNative.Insights.AutoscaleSetting("autoscaleSetting", new()
 *     {
 *         AutoscaleSettingName = "MySetting",
 *         Enabled = true,
 *         Location = "West US",
 *         Notifications = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AutoscaleNotificationArgs
 *             {
 *                 Email = new AzureNative.Insights.Inputs.EmailNotificationArgs
 *                 {
 *                     CustomEmails = new[]
 *                     {
 *                         "gu@ms.com",
 *                         "ge@ns.net",
 *                     },
 *                     SendToSubscriptionAdministrator = true,
 *                     SendToSubscriptionCoAdministrators = true,
 *                 },
 *                 Operation = AzureNative.Insights.OperationType.Scale,
 *                 Webhooks = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.WebhookNotificationArgs
 *                     {
 *                         Properties = null,
 *                         ServiceUri = "http://myservice.com",
 *                     },
 *                 },
 *             },
 *         },
 *         PredictiveAutoscalePolicy = new AzureNative.Insights.Inputs.PredictiveAutoscalePolicyArgs
 *         {
 *             ScaleMode = AzureNative.Insights.PredictiveAutoscalePolicyScaleMode.Enabled,
 *         },
 *         Profiles = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AutoscaleProfileArgs
 *             {
 *                 Capacity = new AzureNative.Insights.Inputs.ScaleCapacityArgs
 *                 {
 *                     Default = "1",
 *                     Maximum = "10",
 *                     Minimum = "1",
 *                 },
 *                 FixedDate = new AzureNative.Insights.Inputs.TimeWindowArgs
 *                 {
 *                     End = "2015-03-05T14:30:00Z",
 *                     Start = "2015-03-05T14:00:00Z",
 *                     TimeZone = "UTC",
 *                 },
 *                 Name = "adios",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.ScaleRuleArgs
 *                     {
 *                         MetricTrigger = new AzureNative.Insights.Inputs.MetricTriggerArgs
 *                         {
 *                             DividePerInstance = false,
 *                             MetricName = "Percentage CPU",
 *                             MetricResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
 *                             Operator = AzureNative.Insights.ComparisonOperationType.GreaterThan,
 *                             Statistic = AzureNative.Insights.MetricStatisticType.Average,
 *                             Threshold = 10,
 *                             TimeAggregation = AzureNative.Insights.TimeAggregationType.Average,
 *                             TimeGrain = "PT1M",
 *                             TimeWindow = "PT5M",
 *                         },
 *                         ScaleAction = new AzureNative.Insights.Inputs.ScaleActionArgs
 *                         {
 *                             Cooldown = "PT5M",
 *                             Direction = AzureNative.Insights.ScaleDirection.Increase,
 *                             Type = AzureNative.Insights.ScaleType.ChangeCount,
 *                             Value = "1",
 *                         },
 *                     },
 *                     new AzureNative.Insights.Inputs.ScaleRuleArgs
 *                     {
 *                         MetricTrigger = new AzureNative.Insights.Inputs.MetricTriggerArgs
 *                         {
 *                             DividePerInstance = false,
 *                             MetricName = "Percentage CPU",
 *                             MetricResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
 *                             Operator = AzureNative.Insights.ComparisonOperationType.GreaterThan,
 *                             Statistic = AzureNative.Insights.MetricStatisticType.Average,
 *                             Threshold = 15,
 *                             TimeAggregation = AzureNative.Insights.TimeAggregationType.Average,
 *                             TimeGrain = "PT2M",
 *                             TimeWindow = "PT5M",
 *                         },
 *                         ScaleAction = new AzureNative.Insights.Inputs.ScaleActionArgs
 *                         {
 *                             Cooldown = "PT6M",
 *                             Direction = AzureNative.Insights.ScaleDirection.Decrease,
 *                             Type = AzureNative.Insights.ScaleType.ChangeCount,
 *                             Value = "2",
 *                         },
 *                     },
 *                 },
 *             },
 *             new AzureNative.Insights.Inputs.AutoscaleProfileArgs
 *             {
 *                 Capacity = new AzureNative.Insights.Inputs.ScaleCapacityArgs
 *                 {
 *                     Default = "1",
 *                     Maximum = "10",
 *                     Minimum = "1",
 *                 },
 *                 Name = "saludos",
 *                 Recurrence = new AzureNative.Insights.Inputs.RecurrenceArgs
 *                 {
 *                     Frequency = AzureNative.Insights.RecurrenceFrequency.Week,
 *                     Schedule = new AzureNative.Insights.Inputs.RecurrentScheduleArgs
 *                     {
 *                         Days = new[]
 *                         {
 *                             "1",
 *                         },
 *                         Hours = new[]
 *                         {
 *                             5,
 *                         },
 *                         Minutes = new[]
 *                         {
 *                             15,
 *                         },
 *                         TimeZone = "UTC",
 *                     },
 *                 },
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.ScaleRuleArgs
 *                     {
 *                         MetricTrigger = new AzureNative.Insights.Inputs.MetricTriggerArgs
 *                         {
 *                             DividePerInstance = false,
 *                             MetricName = "Percentage CPU",
 *                             MetricResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
 *                             Operator = AzureNative.Insights.ComparisonOperationType.GreaterThan,
 *                             Statistic = AzureNative.Insights.MetricStatisticType.Average,
 *                             Threshold = 10,
 *                             TimeAggregation = AzureNative.Insights.TimeAggregationType.Average,
 *                             TimeGrain = "PT1M",
 *                             TimeWindow = "PT5M",
 *                         },
 *                         ScaleAction = new AzureNative.Insights.Inputs.ScaleActionArgs
 *                         {
 *                             Cooldown = "PT5M",
 *                             Direction = AzureNative.Insights.ScaleDirection.Increase,
 *                             Type = AzureNative.Insights.ScaleType.ChangeCount,
 *                             Value = "1",
 *                         },
 *                     },
 *                     new AzureNative.Insights.Inputs.ScaleRuleArgs
 *                     {
 *                         MetricTrigger = new AzureNative.Insights.Inputs.MetricTriggerArgs
 *                         {
 *                             DividePerInstance = false,
 *                             MetricName = "Percentage CPU",
 *                             MetricResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
 *                             Operator = AzureNative.Insights.ComparisonOperationType.GreaterThan,
 *                             Statistic = AzureNative.Insights.MetricStatisticType.Average,
 *                             Threshold = 15,
 *                             TimeAggregation = AzureNative.Insights.TimeAggregationType.Average,
 *                             TimeGrain = "PT2M",
 *                             TimeWindow = "PT5M",
 *                         },
 *                         ScaleAction = new AzureNative.Insights.Inputs.ScaleActionArgs
 *                         {
 *                             Cooldown = "PT6M",
 *                             Direction = AzureNative.Insights.ScaleDirection.Decrease,
 *                             Type = AzureNative.Insights.ScaleType.ChangeCount,
 *                             Value = "2",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "TestingMetricsScaleSet",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *         TargetResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewAutoscaleSetting(ctx, "autoscaleSetting", &insights.AutoscaleSettingArgs{
 * 			AutoscaleSettingName: pulumi.String("MySetting"),
 * 			Enabled:              pulumi.Bool(true),
 * 			Location:             pulumi.String("West US"),
 * 			Notifications: []insights.AutoscaleNotificationArgs{
 * 				{
 * 					Email: {
 * 						CustomEmails: pulumi.StringArray{
 * 							pulumi.String("gu@ms.com"),
 * 							pulumi.String("ge@ns.net"),
 * 						},
 * 						SendToSubscriptionAdministrator:    pulumi.Bool(true),
 * 						SendToSubscriptionCoAdministrators: pulumi.Bool(true),
 * 					},
 * 					Operation: insights.OperationTypeScale,
 * 					Webhooks: insights.WebhookNotificationArray{
 * 						{
 * 							Properties: nil,
 * 							ServiceUri: pulumi.String("http://myservice.com"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			PredictiveAutoscalePolicy: &insights.PredictiveAutoscalePolicyArgs{
 * 				ScaleMode: insights.PredictiveAutoscalePolicyScaleModeEnabled,
 * 			},
 * 			Profiles: []insights.AutoscaleProfileArgs{
 * 				{
 * 					Capacity: {
 * 						Default: pulumi.String("1"),
 * 						Maximum: pulumi.String("10"),
 * 						Minimum: pulumi.String("1"),
 * 					},
 * 					FixedDate: {
 * 						End:      pulumi.String("2015-03-05T14:30:00Z"),
 * 						Start:    pulumi.String("2015-03-05T14:00:00Z"),
 * 						TimeZone: pulumi.String("UTC"),
 * 					},
 * 					Name: pulumi.String("adios"),
 * 					Rules: insights.ScaleRuleArray{
 * 						{
 * 							MetricTrigger: {
 * 								DividePerInstance: pulumi.Bool(false),
 * 								MetricName:        pulumi.String("Percentage CPU"),
 * 								MetricResourceUri: pulumi.String("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 * 								Operator:          insights.ComparisonOperationTypeGreaterThan,
 * 								Statistic:         insights.MetricStatisticTypeAverage,
 * 								Threshold:         pulumi.Float64(10),
 * 								TimeAggregation:   insights.TimeAggregationTypeAverage,
 * 								TimeGrain:         pulumi.String("PT1M"),
 * 								TimeWindow:        pulumi.String("PT5M"),
 * 							},
 * 							ScaleAction: {
 * 								Cooldown:  pulumi.String("PT5M"),
 * 								Direction: insights.ScaleDirectionIncrease,
 * 								Type:      insights.ScaleTypeChangeCount,
 * 								Value:     pulumi.String("1"),
 * 							},
 * 						},
 * 						{
 * 							MetricTrigger: {
 * 								DividePerInstance: pulumi.Bool(false),
 * 								MetricName:        pulumi.String("Percentage CPU"),
 * 								MetricResourceUri: pulumi.String("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 * 								Operator:          insights.ComparisonOperationTypeGreaterThan,
 * 								Statistic:         insights.MetricStatisticTypeAverage,
 * 								Threshold:         pulumi.Float64(15),
 * 								TimeAggregation:   insights.TimeAggregationTypeAverage,
 * 								TimeGrain:         pulumi.String("PT2M"),
 * 								TimeWindow:        pulumi.String("PT5M"),
 * 							},
 * 							ScaleAction: {
 * 								Cooldown:  pulumi.String("PT6M"),
 * 								Direction: insights.ScaleDirectionDecrease,
 * 								Type:      insights.ScaleTypeChangeCount,
 * 								Value:     pulumi.String("2"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				{
 * 					Capacity: {
 * 						Default: pulumi.String("1"),
 * 						Maximum: pulumi.String("10"),
 * 						Minimum: pulumi.String("1"),
 * 					},
 * 					Name: pulumi.String("saludos"),
 * 					Recurrence: {
 * 						Frequency: insights.RecurrenceFrequencyWeek,
 * 						Schedule: {
 * 							Days: pulumi.StringArray{
 * 								pulumi.String("1"),
 * 							},
 * 							Hours: pulumi.IntArray{
 * 								pulumi.Int(5),
 * 							},
 * 							Minutes: pulumi.IntArray{
 * 								pulumi.Int(15),
 * 							},
 * 							TimeZone: pulumi.String("UTC"),
 * 						},
 * 					},
 * 					Rules: insights.ScaleRuleArray{
 * 						{
 * 							MetricTrigger: {
 * 								DividePerInstance: pulumi.Bool(false),
 * 								MetricName:        pulumi.String("Percentage CPU"),
 * 								MetricResourceUri: pulumi.String("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 * 								Operator:          insights.ComparisonOperationTypeGreaterThan,
 * 								Statistic:         insights.MetricStatisticTypeAverage,
 * 								Threshold:         pulumi.Float64(10),
 * 								TimeAggregation:   insights.TimeAggregationTypeAverage,
 * 								TimeGrain:         pulumi.String("PT1M"),
 * 								TimeWindow:        pulumi.String("PT5M"),
 * 							},
 * 							ScaleAction: {
 * 								Cooldown:  pulumi.String("PT5M"),
 * 								Direction: insights.ScaleDirectionIncrease,
 * 								Type:      insights.ScaleTypeChangeCount,
 * 								Value:     pulumi.String("1"),
 * 							},
 * 						},
 * 						{
 * 							MetricTrigger: {
 * 								DividePerInstance: pulumi.Bool(false),
 * 								MetricName:        pulumi.String("Percentage CPU"),
 * 								MetricResourceUri: pulumi.String("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 * 								Operator:          insights.ComparisonOperationTypeGreaterThan,
 * 								Statistic:         insights.MetricStatisticTypeAverage,
 * 								Threshold:         pulumi.Float64(15),
 * 								TimeAggregation:   insights.TimeAggregationTypeAverage,
 * 								TimeGrain:         pulumi.String("PT2M"),
 * 								TimeWindow:        pulumi.String("PT5M"),
 * 							},
 * 							ScaleAction: {
 * 								Cooldown:  pulumi.String("PT6M"),
 * 								Direction: insights.ScaleDirectionDecrease,
 * 								Type:      insights.ScaleTypeChangeCount,
 * 								Value:     pulumi.String("2"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("TestingMetricsScaleSet"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 			TargetResourceUri: pulumi.String("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.AutoscaleSetting;
 * import com.pulumi.azurenative.insights.AutoscaleSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var autoscaleSetting = new AutoscaleSetting("autoscaleSetting", AutoscaleSettingArgs.builder()
 *             .autoscaleSettingName("MySetting")
 *             .enabled(true)
 *             .location("West US")
 *             .notifications(Map.ofEntries(
 *                 Map.entry("email", Map.ofEntries(
 *                     Map.entry("customEmails",
 *                         "gu@ms.com",
 *                         "ge@ns.net"),
 *                     Map.entry("sendToSubscriptionAdministrator", true),
 *                     Map.entry("sendToSubscriptionCoAdministrators", true)
 *                 )),
 *                 Map.entry("operation", "Scale"),
 *                 Map.entry("webhooks", Map.ofEntries(
 *                     Map.entry("properties", ),
 *                     Map.entry("serviceUri", "http://myservice.com")
 *                 ))
 *             ))
 *             .predictiveAutoscalePolicy(Map.of("scaleMode", "Enabled"))
 *             .profiles(
 *                 Map.ofEntries(
 *                     Map.entry("capacity", Map.ofEntries(
 *                         Map.entry("default", "1"),
 *                         Map.entry("maximum", "10"),
 *                         Map.entry("minimum", "1")
 *                     )),
 *                     Map.entry("fixedDate", Map.ofEntries(
 *                         Map.entry("end", "2015-03-05T14:30:00Z"),
 *                         Map.entry("start", "2015-03-05T14:00:00Z"),
 *                         Map.entry("timeZone", "UTC")
 *                     )),
 *                     Map.entry("name", "adios"),
 *                     Map.entry("rules",
 *                         Map.ofEntries(
 *                             Map.entry("metricTrigger", Map.ofEntries(
 *                                 Map.entry("dividePerInstance", false),
 *                                 Map.entry("metricName", "Percentage CPU"),
 *                                 Map.entry("metricResourceUri", "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 *                                 Map.entry("operator", "GreaterThan"),
 *                                 Map.entry("statistic", "Average"),
 *                                 Map.entry("threshold", 10),
 *                                 Map.entry("timeAggregation", "Average"),
 *                                 Map.entry("timeGrain", "PT1M"),
 *                                 Map.entry("timeWindow", "PT5M")
 *                             )),
 *                             Map.entry("scaleAction", Map.ofEntries(
 *                                 Map.entry("cooldown", "PT5M"),
 *                                 Map.entry("direction", "Increase"),
 *                                 Map.entry("type", "ChangeCount"),
 *                                 Map.entry("value", "1")
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("metricTrigger", Map.ofEntries(
 *                                 Map.entry("dividePerInstance", false),
 *                                 Map.entry("metricName", "Percentage CPU"),
 *                                 Map.entry("metricResourceUri", "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 *                                 Map.entry("operator", "GreaterThan"),
 *                                 Map.entry("statistic", "Average"),
 *                                 Map.entry("threshold", 15),
 *                                 Map.entry("timeAggregation", "Average"),
 *                                 Map.entry("timeGrain", "PT2M"),
 *                                 Map.entry("timeWindow", "PT5M")
 *                             )),
 *                             Map.entry("scaleAction", Map.ofEntries(
 *                                 Map.entry("cooldown", "PT6M"),
 *                                 Map.entry("direction", "Decrease"),
 *                                 Map.entry("type", "ChangeCount"),
 *                                 Map.entry("value", "2")
 *                             ))
 *                         ))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("capacity", Map.ofEntries(
 *                         Map.entry("default", "1"),
 *                         Map.entry("maximum", "10"),
 *                         Map.entry("minimum", "1")
 *                     )),
 *                     Map.entry("name", "saludos"),
 *                     Map.entry("recurrence", Map.ofEntries(
 *                         Map.entry("frequency", "Week"),
 *                         Map.entry("schedule", Map.ofEntries(
 *                             Map.entry("days", "1"),
 *                             Map.entry("hours", 5),
 *                             Map.entry("minutes", 15),
 *                             Map.entry("timeZone", "UTC")
 *                         ))
 *                     )),
 *                     Map.entry("rules",
 *                         Map.ofEntries(
 *                             Map.entry("metricTrigger", Map.ofEntries(
 *                                 Map.entry("dividePerInstance", false),
 *                                 Map.entry("metricName", "Percentage CPU"),
 *                                 Map.entry("metricResourceUri", "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 *                                 Map.entry("operator", "GreaterThan"),
 *                                 Map.entry("statistic", "Average"),
 *                                 Map.entry("threshold", 10),
 *                                 Map.entry("timeAggregation", "Average"),
 *                                 Map.entry("timeGrain", "PT1M"),
 *                                 Map.entry("timeWindow", "PT5M")
 *                             )),
 *                             Map.entry("scaleAction", Map.ofEntries(
 *                                 Map.entry("cooldown", "PT5M"),
 *                                 Map.entry("direction", "Increase"),
 *                                 Map.entry("type", "ChangeCount"),
 *                                 Map.entry("value", "1")
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("metricTrigger", Map.ofEntries(
 *                                 Map.entry("dividePerInstance", false),
 *                                 Map.entry("metricName", "Percentage CPU"),
 *                                 Map.entry("metricResourceUri", "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc"),
 *                                 Map.entry("operator", "GreaterThan"),
 *                                 Map.entry("statistic", "Average"),
 *                                 Map.entry("threshold", 15),
 *                                 Map.entry("timeAggregation", "Average"),
 *                                 Map.entry("timeGrain", "PT2M"),
 *                                 Map.entry("timeWindow", "PT5M")
 *                             )),
 *                             Map.entry("scaleAction", Map.ofEntries(
 *                                 Map.entry("cooldown", "PT6M"),
 *                                 Map.entry("direction", "Decrease"),
 *                                 Map.entry("type", "ChangeCount"),
 *                                 Map.entry("value", "2")
 *                             ))
 *                         ))
 *                 ))
 *             .resourceGroupName("TestingMetricsScaleSet")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .targetResourceUri("/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:AutoscaleSetting MySetting /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Insights/autoscalesettings/{autoscaleSettingName}
 * ```
 * @property autoscaleSettingName The autoscale setting name.
 * @property enabled the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'.
 * @property location Resource location
 * @property name the name of the autoscale setting.
 * @property notifications the collection of notifications.
 * @property predictiveAutoscalePolicy the predictive autoscale policy mode.
 * @property profiles the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
 * @property targetResourceLocation the location of the resource that the autoscale setting should be added to.
 * @property targetResourceUri the resource identifier of the resource that the autoscale setting should be added to.
 */
public data class AutoscaleSettingArgs(
    public val autoscaleSettingName: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val notifications: Output<List<AutoscaleNotificationArgs>>? = null,
    public val predictiveAutoscalePolicy: Output<PredictiveAutoscalePolicyArgs>? = null,
    public val profiles: Output<List<AutoscaleProfileArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceLocation: Output<String>? = null,
    public val targetResourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.AutoscaleSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.AutoscaleSettingArgs =
        com.pulumi.azurenative.insights.AutoscaleSettingArgs.builder()
            .autoscaleSettingName(autoscaleSettingName?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notifications(
                notifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .predictiveAutoscalePolicy(
                predictiveAutoscalePolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .profiles(
                profiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceLocation(targetResourceLocation?.applyValue({ args0 -> args0 }))
            .targetResourceUri(targetResourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoscaleSettingArgs].
 */
@PulumiTagMarker
public class AutoscaleSettingArgsBuilder internal constructor() {
    private var autoscaleSettingName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var notifications: Output<List<AutoscaleNotificationArgs>>? = null

    private var predictiveAutoscalePolicy: Output<PredictiveAutoscalePolicyArgs>? = null

    private var profiles: Output<List<AutoscaleProfileArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceLocation: Output<String>? = null

    private var targetResourceUri: Output<String>? = null

    /**
     * @param value The autoscale setting name.
     */
    @JvmName("pgqlfcsssnnkggbn")
    public suspend fun autoscaleSettingName(`value`: Output<String>) {
        this.autoscaleSettingName = value
    }

    /**
     * @param value the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'.
     */
    @JvmName("fmvmswnovignoqhy")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("ffuwomrdxtpptyck")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value the name of the autoscale setting.
     */
    @JvmName("ycpgeaggtikiqery")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value the collection of notifications.
     */
    @JvmName("oawmsacmbgurlwww")
    public suspend fun notifications(`value`: Output<List<AutoscaleNotificationArgs>>) {
        this.notifications = value
    }

    @JvmName("ffhdupbucvrogwcj")
    public suspend fun notifications(vararg values: Output<AutoscaleNotificationArgs>) {
        this.notifications = Output.all(values.asList())
    }

    /**
     * @param values the collection of notifications.
     */
    @JvmName("tcrtwafrliunbbac")
    public suspend fun notifications(values: List<Output<AutoscaleNotificationArgs>>) {
        this.notifications = Output.all(values)
    }

    /**
     * @param value the predictive autoscale policy mode.
     */
    @JvmName("cyjeebfyvycswdpt")
    public suspend fun predictiveAutoscalePolicy(`value`: Output<PredictiveAutoscalePolicyArgs>) {
        this.predictiveAutoscalePolicy = value
    }

    /**
     * @param value the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
     */
    @JvmName("yipyjyxmmsybjpos")
    public suspend fun profiles(`value`: Output<List<AutoscaleProfileArgs>>) {
        this.profiles = value
    }

    @JvmName("qkryqjipbtjosvsr")
    public suspend fun profiles(vararg values: Output<AutoscaleProfileArgs>) {
        this.profiles = Output.all(values.asList())
    }

    /**
     * @param values the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
     */
    @JvmName("kbtnyqdixirmfgpu")
    public suspend fun profiles(values: List<Output<AutoscaleProfileArgs>>) {
        this.profiles = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xuoiekdtnowrsmbw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
     */
    @JvmName("wneglfosgfkpsoca")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value the location of the resource that the autoscale setting should be added to.
     */
    @JvmName("mlhbickpfejstutc")
    public suspend fun targetResourceLocation(`value`: Output<String>) {
        this.targetResourceLocation = value
    }

    /**
     * @param value the resource identifier of the resource that the autoscale setting should be added to.
     */
    @JvmName("xmqrisspgqdccjxv")
    public suspend fun targetResourceUri(`value`: Output<String>) {
        this.targetResourceUri = value
    }

    /**
     * @param value The autoscale setting name.
     */
    @JvmName("bvwrdlbbbhywbspf")
    public suspend fun autoscaleSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscaleSettingName = mapped
    }

    /**
     * @param value the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'.
     */
    @JvmName("wqrdhnmdecfilikw")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("cvykyhqfwbdcgefi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value the name of the autoscale setting.
     */
    @JvmName("xnxrxwgfuylkvhqs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value the collection of notifications.
     */
    @JvmName("idlwyisxkuytvryq")
    public suspend fun notifications(`value`: List<AutoscaleNotificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param argument the collection of notifications.
     */
    @JvmName("fuijyqajrvvwuamw")
    public suspend
    fun notifications(argument: List<suspend AutoscaleNotificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutoscaleNotificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notifications = mapped
    }

    /**
     * @param argument the collection of notifications.
     */
    @JvmName("dwmmhqnaixxfvqin")
    public suspend fun notifications(
        vararg
        argument: suspend AutoscaleNotificationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AutoscaleNotificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notifications = mapped
    }

    /**
     * @param argument the collection of notifications.
     */
    @JvmName("xxnqcditvsbicpvg")
    public suspend fun notifications(argument: suspend AutoscaleNotificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AutoscaleNotificationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.notifications = mapped
    }

    /**
     * @param values the collection of notifications.
     */
    @JvmName("raobrekrewonhbev")
    public suspend fun notifications(vararg values: AutoscaleNotificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param value the predictive autoscale policy mode.
     */
    @JvmName("khccgnwbyumxqtgu")
    public suspend fun predictiveAutoscalePolicy(`value`: PredictiveAutoscalePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predictiveAutoscalePolicy = mapped
    }

    /**
     * @param argument the predictive autoscale policy mode.
     */
    @JvmName("okccorcvtttciatn")
    public suspend
    fun predictiveAutoscalePolicy(argument: suspend PredictiveAutoscalePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = PredictiveAutoscalePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.predictiveAutoscalePolicy = mapped
    }

    /**
     * @param value the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
     */
    @JvmName("linkscpgmansuugv")
    public suspend fun profiles(`value`: List<AutoscaleProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profiles = mapped
    }

    /**
     * @param argument the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
     */
    @JvmName("qegaurqvsardluyl")
    public suspend fun profiles(argument: List<suspend AutoscaleProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutoscaleProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.profiles = mapped
    }

    /**
     * @param argument the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
     */
    @JvmName("jebydnlkxhbuhqqf")
    public suspend fun profiles(vararg argument: suspend AutoscaleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutoscaleProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.profiles = mapped
    }

    /**
     * @param argument the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
     */
    @JvmName("dywvpmpvuahnivcp")
    public suspend fun profiles(argument: suspend AutoscaleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AutoscaleProfileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.profiles = mapped
    }

    /**
     * @param values the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
     */
    @JvmName("xupxfyatymvtiyrh")
    public suspend fun profiles(vararg values: AutoscaleProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profiles = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("umiqspaqebdcvvew")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
     */
    @JvmName("oglpywqvcwkworex")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
     */
    @JvmName("xufuvhwaxrbkybia")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value the location of the resource that the autoscale setting should be added to.
     */
    @JvmName("ppacoxsulbqwyskm")
    public suspend fun targetResourceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceLocation = mapped
    }

    /**
     * @param value the resource identifier of the resource that the autoscale setting should be added to.
     */
    @JvmName("ttppjyssrtslbqnf")
    public suspend fun targetResourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceUri = mapped
    }

    internal fun build(): AutoscaleSettingArgs = AutoscaleSettingArgs(
        autoscaleSettingName = autoscaleSettingName,
        enabled = enabled,
        location = location,
        name = name,
        notifications = notifications,
        predictiveAutoscalePolicy = predictiveAutoscalePolicy,
        profiles = profiles,
        resourceGroupName = resourceGroupName,
        tags = tags,
        targetResourceLocation = targetResourceLocation,
        targetResourceUri = targetResourceUri,
    )
}
