@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.DataCollectionRuleArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownDataCollectionRuleResourceKind
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleDataSourcesArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleDataSourcesArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleDestinationsArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleDestinationsArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleResourceIdentityArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleResourceIdentityArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.DataFlowArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataFlowArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.StreamDeclarationArgs
import com.pulumi.azurenative.insights.kotlin.inputs.StreamDeclarationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of ARM tracked top level resource.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * ## Example Usage
 * ### Create or update data collection rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataCollectionRule = new AzureNative.Insights.DataCollectionRule("dataCollectionRule", new()
 *     {
 *         DataCollectionRuleName = "myCollectionRule",
 *         DataFlows = new[]
 *         {
 *             new AzureNative.Insights.Inputs.DataFlowArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "centralWorkspace",
 *                 },
 *                 Streams = new[]
 *                 {
 *                     "Microsoft-Perf",
 *                     "Microsoft-Syslog",
 *                     "Microsoft-WindowsEvent",
 *                 },
 *             },
 *         },
 *         DataSources = new AzureNative.Insights.Inputs.DataCollectionRuleDataSourcesArgs
 *         {
 *             PerformanceCounters = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.PerfCounterDataSourceArgs
 *                 {
 *                     CounterSpecifiers = new[]
 *                     {
 *                         "\\Processor(_Total)\\% Processor Time",
 *                         "\\Memory\\Committed Bytes",
 *                         "\\LogicalDisk(_Total)\\Free Megabytes",
 *                         "\\PhysicalDisk(_Total)\\Avg. Disk Queue Length",
 *                     },
 *                     Name = "cloudTeamCoreCounters",
 *                     SamplingFrequencyInSeconds = 15,
 *                     Streams = new[]
 *                     {
 *                         "Microsoft-Perf",
 *                     },
 *                 },
 *                 new AzureNative.Insights.Inputs.PerfCounterDataSourceArgs
 *                 {
 *                     CounterSpecifiers = new[]
 *                     {
 *                         "\\Process(_Total)\\Thread Count",
 *                     },
 *                     Name = "appTeamExtraCounters",
 *                     SamplingFrequencyInSeconds = 30,
 *                     Streams = new[]
 *                     {
 *                         "Microsoft-Perf",
 *                     },
 *                 },
 *             },
 *             Syslog = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.SyslogDataSourceArgs
 *                 {
 *                     FacilityNames = new[]
 *                     {
 *                         "cron",
 *                     },
 *                     LogLevels = new[]
 *                     {
 *                         "Debug",
 *                         "Critical",
 *                         "Emergency",
 *                     },
 *                     Name = "cronSyslog",
 *                     Streams = new[]
 *                     {
 *                         "Microsoft-Syslog",
 *                     },
 *                 },
 *                 new AzureNative.Insights.Inputs.SyslogDataSourceArgs
 *                 {
 *                     FacilityNames = new[]
 *                     {
 *                         "syslog",
 *                     },
 *                     LogLevels = new[]
 *                     {
 *                         "Alert",
 *                         "Critical",
 *                         "Emergency",
 *                     },
 *                     Name = "syslogBase",
 *                     Streams = new[]
 *                     {
 *                         "Microsoft-Syslog",
 *                     },
 *                 },
 *             },
 *             WindowsEventLogs = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.WindowsEventLogDataSourceArgs
 *                 {
 *                     Name = "cloudSecurityTeamEvents",
 *                     Streams = new[]
 *                     {
 *                         "Microsoft-WindowsEvent",
 *                     },
 *                     XPathQueries = new[]
 *                     {
 *                         "Security!",
 *                     },
 *                 },
 *                 new AzureNative.Insights.Inputs.WindowsEventLogDataSourceArgs
 *                 {
 *                     Name = "appTeam1AppEvents",
 *                     Streams = new[]
 *                     {
 *                         "Microsoft-WindowsEvent",
 *                     },
 *                     XPathQueries = new[]
 *                     {
 *                         "System![System[(Level = 1 or Level = 2 or Level = 3)]]",
 *                         "Application!*[System[(Level = 1 or Level = 2 or Level = 3)]]",
 *                     },
 *                 },
 *             },
 *         },
 *         Destinations = new AzureNative.Insights.Inputs.DataCollectionRuleDestinationsArgs
 *         {
 *             LogAnalytics = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.LogAnalyticsDestinationArgs
 *                 {
 *                     Name = "centralWorkspace",
 *                     WorkspaceResourceId = "/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.OperationalInsights/workspaces/centralTeamWorkspace",
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDataCollectionRule(ctx, "dataCollectionRule", &insights.DataCollectionRuleArgs{
 * 			DataCollectionRuleName: pulumi.String("myCollectionRule"),
 * 			DataFlows: []insights.DataFlowArgs{
 * 				{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("centralWorkspace"),
 * 					},
 * 					Streams: pulumi.StringArray{
 * 						pulumi.String("Microsoft-Perf"),
 * 						pulumi.String("Microsoft-Syslog"),
 * 						pulumi.String("Microsoft-WindowsEvent"),
 * 					},
 * 				},
 * 			},
 * 			DataSources: insights.DataCollectionRuleResponseDataSources{
 * 				PerformanceCounters: insights.PerfCounterDataSourceArray{
 * 					&insights.PerfCounterDataSourceArgs{
 * 						CounterSpecifiers: pulumi.StringArray{
 * 							pulumi.String("\\Processor(_Total)\\% Processor Time"),
 * 							pulumi.String("\\Memory\\Committed Bytes"),
 * 							pulumi.String("\\LogicalDisk(_Total)\\Free Megabytes"),
 * 							pulumi.String("\\PhysicalDisk(_Total)\\Avg. Disk Queue Length"),
 * 						},
 * 						Name:                       pulumi.String("cloudTeamCoreCounters"),
 * 						SamplingFrequencyInSeconds: pulumi.Int(15),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String("Microsoft-Perf"),
 * 						},
 * 					},
 * 					&insights.PerfCounterDataSourceArgs{
 * 						CounterSpecifiers: pulumi.StringArray{
 * 							pulumi.String("\\Process(_Total)\\Thread Count"),
 * 						},
 * 						Name:                       pulumi.String("appTeamExtraCounters"),
 * 						SamplingFrequencyInSeconds: pulumi.Int(30),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String("Microsoft-Perf"),
 * 						},
 * 					},
 * 				},
 * 				Syslog: insights.SyslogDataSourceArray{
 * 					&insights.SyslogDataSourceArgs{
 * 						FacilityNames: pulumi.StringArray{
 * 							pulumi.String("cron"),
 * 						},
 * 						LogLevels: pulumi.StringArray{
 * 							pulumi.String("Debug"),
 * 							pulumi.String("Critical"),
 * 							pulumi.String("Emergency"),
 * 						},
 * 						Name: pulumi.String("cronSyslog"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String("Microsoft-Syslog"),
 * 						},
 * 					},
 * 					&insights.SyslogDataSourceArgs{
 * 						FacilityNames: pulumi.StringArray{
 * 							pulumi.String("syslog"),
 * 						},
 * 						LogLevels: pulumi.StringArray{
 * 							pulumi.String("Alert"),
 * 							pulumi.String("Critical"),
 * 							pulumi.String("Emergency"),
 * 						},
 * 						Name: pulumi.String("syslogBase"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String("Microsoft-Syslog"),
 * 						},
 * 					},
 * 				},
 * 				WindowsEventLogs: insights.WindowsEventLogDataSourceArray{
 * 					&insights.WindowsEventLogDataSourceArgs{
 * 						Name: pulumi.String("cloudSecurityTeamEvents"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String("Microsoft-WindowsEvent"),
 * 						},
 * 						XPathQueries: pulumi.StringArray{
 * 							pulumi.String("Security!"),
 * 						},
 * 					},
 * 					&insights.WindowsEventLogDataSourceArgs{
 * 						Name: pulumi.String("appTeam1AppEvents"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String("Microsoft-WindowsEvent"),
 * 						},
 * 						XPathQueries: pulumi.StringArray{
 * 							pulumi.String("System![System[(Level = 1 or Level = 2 or Level = 3)]]"),
 * 							pulumi.String("Application!*[System[(Level = 1 or Level = 2 or Level = 3)]]"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Destinations: insights.DataCollectionRuleResponseDestinations{
 * 				LogAnalytics: insights.LogAnalyticsDestinationArray{
 * 					&insights.LogAnalyticsDestinationArgs{
 * 						Name:                pulumi.String("centralWorkspace"),
 * 						WorkspaceResourceId: pulumi.String("/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.OperationalInsights/workspaces/centralTeamWorkspace"),
 * 					},
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DataCollectionRule;
 * import com.pulumi.azurenative.insights.DataCollectionRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataCollectionRule = new DataCollectionRule("dataCollectionRule", DataCollectionRuleArgs.builder()
 *             .dataCollectionRuleName("myCollectionRule")
 *             .dataFlows(Map.ofEntries(
 *                 Map.entry("destinations", "centralWorkspace"),
 *                 Map.entry("streams",
 *                     "Microsoft-Perf",
 *                     "Microsoft-Syslog",
 *                     "Microsoft-WindowsEvent")
 *             ))
 *             .dataSources(Map.ofEntries(
 *                 Map.entry("performanceCounters",
 *                     Map.ofEntries(
 *                         Map.entry("counterSpecifiers",
 *                             "\\Processor(_Total)\\% Processor Time",
 *                             "\\Memory\\Committed Bytes",
 *                             "\\LogicalDisk(_Total)\\Free Megabytes",
 *                             "\\PhysicalDisk(_Total)\\Avg. Disk Queue Length"),
 *                         Map.entry("name", "cloudTeamCoreCounters"),
 *                         Map.entry("samplingFrequencyInSeconds", 15),
 *                         Map.entry("streams", "Microsoft-Perf")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("counterSpecifiers", "\\Process(_Total)\\Thread Count"),
 *                         Map.entry("name", "appTeamExtraCounters"),
 *                         Map.entry("samplingFrequencyInSeconds", 30),
 *                         Map.entry("streams", "Microsoft-Perf")
 *                     )),
 *                 Map.entry("syslog",
 *                     Map.ofEntries(
 *                         Map.entry("facilityNames", "cron"),
 *                         Map.entry("logLevels",
 *                             "Debug",
 *                             "Critical",
 *                             "Emergency"),
 *                         Map.entry("name", "cronSyslog"),
 *                         Map.entry("streams", "Microsoft-Syslog")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("facilityNames", "syslog"),
 *                         Map.entry("logLevels",
 *                             "Alert",
 *                             "Critical",
 *                             "Emergency"),
 *                         Map.entry("name", "syslogBase"),
 *                         Map.entry("streams", "Microsoft-Syslog")
 *                     )),
 *                 Map.entry("windowsEventLogs",
 *                     Map.ofEntries(
 *                         Map.entry("name", "cloudSecurityTeamEvents"),
 *                         Map.entry("streams", "Microsoft-WindowsEvent"),
 *                         Map.entry("xPathQueries", "Security!")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("name", "appTeam1AppEvents"),
 *                         Map.entry("streams", "Microsoft-WindowsEvent"),
 *                         Map.entry("xPathQueries",
 *                             "System![System[(Level = 1 or Level = 2 or Level = 3)]]",
 *                             "Application!*[System[(Level = 1 or Level = 2 or Level = 3)]]")
 *                     ))
 *             ))
 *             .destinations(Map.of("logAnalytics", Map.ofEntries(
 *                 Map.entry("name", "centralWorkspace"),
 *                 Map.entry("workspaceResourceId", "/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.OperationalInsights/workspaces/centralTeamWorkspace")
 *             )))
 *             .location("eastus")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:DataCollectionRule myCollectionRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dataCollectionRuleName}
 * ```
 * @property dataCollectionEndpointId The resource ID of the data collection endpoint that this rule can be used with.
 * @property dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
 * @property dataFlows The specification of data flows.
 * @property dataSources The specification of data sources.
 * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
 * @property description Description of the data collection rule.
 * @property destinations The specification of destinations.
 * @property identity Managed service identity of the resource.
 * @property kind The kind of the resource.
 * @property location The geo-location where the resource lives.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property streamDeclarations Declaration of custom streams used in this rule.
 * @property tags Resource tags.
 */
public data class DataCollectionRuleArgs(
    public val dataCollectionEndpointId: Output<String>? = null,
    public val dataCollectionRuleName: Output<String>? = null,
    public val dataFlows: Output<List<DataFlowArgs>>? = null,
    public val dataSources: Output<DataCollectionRuleDataSourcesArgs>? = null,
    public val description: Output<String>? = null,
    public val destinations: Output<DataCollectionRuleDestinationsArgs>? = null,
    public val identity: Output<DataCollectionRuleResourceIdentityArgs>? = null,
    public val kind: Output<Either<String, KnownDataCollectionRuleResourceKind>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val streamDeclarations: Output<Map<String, StreamDeclarationArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.DataCollectionRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.DataCollectionRuleArgs =
        com.pulumi.azurenative.insights.DataCollectionRuleArgs.builder()
            .dataCollectionEndpointId(dataCollectionEndpointId?.applyValue({ args0 -> args0 }))
            .dataCollectionRuleName(dataCollectionRuleName?.applyValue({ args0 -> args0 }))
            .dataFlows(
                dataFlows?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataSources(dataSources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destinations(destinations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .streamDeclarations(
                streamDeclarations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataCollectionRuleArgs].
 */
@PulumiTagMarker
public class DataCollectionRuleArgsBuilder internal constructor() {
    private var dataCollectionEndpointId: Output<String>? = null

    private var dataCollectionRuleName: Output<String>? = null

    private var dataFlows: Output<List<DataFlowArgs>>? = null

    private var dataSources: Output<DataCollectionRuleDataSourcesArgs>? = null

    private var description: Output<String>? = null

    private var destinations: Output<DataCollectionRuleDestinationsArgs>? = null

    private var identity: Output<DataCollectionRuleResourceIdentityArgs>? = null

    private var kind: Output<Either<String, KnownDataCollectionRuleResourceKind>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var streamDeclarations: Output<Map<String, StreamDeclarationArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The resource ID of the data collection endpoint that this rule can be used with.
     */
    @JvmName("hrjyjifnqlkehktc")
    public suspend fun dataCollectionEndpointId(`value`: Output<String>) {
        this.dataCollectionEndpointId = value
    }

    /**
     * @param value The name of the data collection rule. The name is case insensitive.
     */
    @JvmName("krahjyiixvsapdvk")
    public suspend fun dataCollectionRuleName(`value`: Output<String>) {
        this.dataCollectionRuleName = value
    }

    /**
     * @param value The specification of data flows.
     */
    @JvmName("wpqojwisfpnprbqs")
    public suspend fun dataFlows(`value`: Output<List<DataFlowArgs>>) {
        this.dataFlows = value
    }

    @JvmName("vbicynvcsoupghff")
    public suspend fun dataFlows(vararg values: Output<DataFlowArgs>) {
        this.dataFlows = Output.all(values.asList())
    }

    /**
     * @param values The specification of data flows.
     */
    @JvmName("hgutgjpatkshicom")
    public suspend fun dataFlows(values: List<Output<DataFlowArgs>>) {
        this.dataFlows = Output.all(values)
    }

    /**
     * @param value The specification of data sources.
     * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
     */
    @JvmName("erdnsrfyprxaihjq")
    public suspend fun dataSources(`value`: Output<DataCollectionRuleDataSourcesArgs>) {
        this.dataSources = value
    }

    /**
     * @param value Description of the data collection rule.
     */
    @JvmName("pwqpvjysgqyeymhm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The specification of destinations.
     */
    @JvmName("wpoppbvfwplfedal")
    public suspend fun destinations(`value`: Output<DataCollectionRuleDestinationsArgs>) {
        this.destinations = value
    }

    /**
     * @param value Managed service identity of the resource.
     */
    @JvmName("ecuwnipombelgxda")
    public suspend fun identity(`value`: Output<DataCollectionRuleResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("ttbkwtuyckyuxwrd")
    public suspend fun kind(`value`: Output<Either<String, KnownDataCollectionRuleResourceKind>>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("mkpqtoqxbcaepwai")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ginboknrklcdiysn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Declaration of custom streams used in this rule.
     */
    @JvmName("vpufklvsjmarjdsf")
    public suspend fun streamDeclarations(`value`: Output<Map<String, StreamDeclarationArgs>>) {
        this.streamDeclarations = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ylipqtokfbdvpxyb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The resource ID of the data collection endpoint that this rule can be used with.
     */
    @JvmName("owequmpqakslveoq")
    public suspend fun dataCollectionEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCollectionEndpointId = mapped
    }

    /**
     * @param value The name of the data collection rule. The name is case insensitive.
     */
    @JvmName("ibrrinsiguvxwcis")
    public suspend fun dataCollectionRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCollectionRuleName = mapped
    }

    /**
     * @param value The specification of data flows.
     */
    @JvmName("dyojdncfknxgxjhj")
    public suspend fun dataFlows(`value`: List<DataFlowArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFlows = mapped
    }

    /**
     * @param argument The specification of data flows.
     */
    @JvmName("lmhnwnvxdexsgsft")
    public suspend fun dataFlows(argument: List<suspend DataFlowArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DataFlowArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataFlows = mapped
    }

    /**
     * @param argument The specification of data flows.
     */
    @JvmName("elgwnofmherheoyh")
    public suspend fun dataFlows(vararg argument: suspend DataFlowArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DataFlowArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataFlows = mapped
    }

    /**
     * @param argument The specification of data flows.
     */
    @JvmName("fosgswxywtvrfbno")
    public suspend fun dataFlows(argument: suspend DataFlowArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataFlowArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataFlows = mapped
    }

    /**
     * @param values The specification of data flows.
     */
    @JvmName("wmhkarcfkiijshvy")
    public suspend fun dataFlows(vararg values: DataFlowArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFlows = mapped
    }

    /**
     * @param value The specification of data sources.
     * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
     */
    @JvmName("mioltnbagwfjqjjf")
    public suspend fun dataSources(`value`: DataCollectionRuleDataSourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSources = mapped
    }

    /**
     * @param argument The specification of data sources.
     * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
     */
    @JvmName("yopmojjvcmvbcevp")
    public suspend
    fun dataSources(argument: suspend DataCollectionRuleDataSourcesArgsBuilder.() -> Unit) {
        val toBeMapped = DataCollectionRuleDataSourcesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataSources = mapped
    }

    /**
     * @param value Description of the data collection rule.
     */
    @JvmName("lcavakkddynidsmh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The specification of destinations.
     */
    @JvmName("lqvobrvwibyepwwv")
    public suspend fun destinations(`value`: DataCollectionRuleDestinationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument The specification of destinations.
     */
    @JvmName("eldpicjerrkbrmig")
    public suspend
    fun destinations(argument: suspend DataCollectionRuleDestinationsArgsBuilder.() -> Unit) {
        val toBeMapped = DataCollectionRuleDestinationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param value Managed service identity of the resource.
     */
    @JvmName("tjwstvvjmfgogkji")
    public suspend fun identity(`value`: DataCollectionRuleResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity of the resource.
     */
    @JvmName("ghwfgwacmbsclrox")
    public suspend
    fun identity(argument: suspend DataCollectionRuleResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DataCollectionRuleResourceIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("gjlnpcsuipxmtwwj")
    public suspend fun kind(`value`: Either<String, KnownDataCollectionRuleResourceKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("ewekpddsgvsxdnol")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KnownDataCollectionRuleResourceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("hkawddqyywjpwcmu")
    public fun kind(`value`: KnownDataCollectionRuleResourceKind) {
        val toBeMapped = Either.ofRight<String, KnownDataCollectionRuleResourceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("lecgcsxkvuwqwkua")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ultnnqrrbdcurpkw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Declaration of custom streams used in this rule.
     */
    @JvmName("erqcawwjoiqqrmie")
    public suspend fun streamDeclarations(`value`: Map<String, StreamDeclarationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamDeclarations = mapped
    }

    /**
     * @param argument Declaration of custom streams used in this rule.
     */
    @JvmName("cjvtoafjfekdxoun")
    public suspend fun streamDeclarations(
        vararg
        argument: Pair<String, suspend StreamDeclarationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                StreamDeclarationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.streamDeclarations = mapped
    }

    /**
     * @param values Declaration of custom streams used in this rule.
     */
    @JvmName("qfndvmsycfktqbwg")
    public fun streamDeclarations(vararg values: Pair<String, StreamDeclarationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamDeclarations = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wqkvuaiatcbmeisk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nriwmndgqfsiacia")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataCollectionRuleArgs = DataCollectionRuleArgs(
        dataCollectionEndpointId = dataCollectionEndpointId,
        dataCollectionRuleName = dataCollectionRuleName,
        dataFlows = dataFlows,
        dataSources = dataSources,
        description = description,
        destinations = destinations,
        identity = identity,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
        streamDeclarations = streamDeclarations,
        tags = tags,
    )
}
