@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleAssociationProxyOnlyResourceResponseSystemData
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleAssociationResponseMetadata
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleAssociationProxyOnlyResourceResponseSystemData.Companion.toKotlin as dataCollectionRuleAssociationProxyOnlyResourceResponseSystemDataToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleAssociationResponseMetadata.Companion.toKotlin as dataCollectionRuleAssociationResponseMetadataToKotlin

/**
 * Builder for [DataCollectionRuleAssociation].
 */
@PulumiTagMarker
public class DataCollectionRuleAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataCollectionRuleAssociationArgs = DataCollectionRuleAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataCollectionRuleAssociationArgsBuilder.() -> Unit) {
        val builder = DataCollectionRuleAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataCollectionRuleAssociation {
        val builtJavaResource =
            com.pulumi.azurenative.insights.DataCollectionRuleAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataCollectionRuleAssociation(builtJavaResource)
    }
}

/**
 * Definition of generic ARM proxy resource.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * ## Example Usage
 * ### Create or update association
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataCollectionRuleAssociation = new AzureNative.Insights.DataCollectionRuleAssociation("dataCollectionRuleAssociation", new()
 *     {
 *         AssociationName = "myAssociation",
 *         DataCollectionRuleId = "/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Insights/dataCollectionRules/myCollectionRule",
 *         ResourceUri = "subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDataCollectionRuleAssociation(ctx, "dataCollectionRuleAssociation", &insights.DataCollectionRuleAssociationArgs{
 * 			AssociationName:      pulumi.String("myAssociation"),
 * 			DataCollectionRuleId: pulumi.String("/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Insights/dataCollectionRules/myCollectionRule"),
 * 			ResourceUri:          pulumi.String("subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DataCollectionRuleAssociation;
 * import com.pulumi.azurenative.insights.DataCollectionRuleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataCollectionRuleAssociation = new DataCollectionRuleAssociation("dataCollectionRuleAssociation", DataCollectionRuleAssociationArgs.builder()
 *             .associationName("myAssociation")
 *             .dataCollectionRuleId("/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Insights/dataCollectionRules/myCollectionRule")
 *             .resourceUri("subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:DataCollectionRuleAssociation myAssociation /{resourceUri}/providers/Microsoft.Insights/dataCollectionRuleAssociations/{associationName}
 * ```
 */
public class DataCollectionRuleAssociation internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.DataCollectionRuleAssociation,
) : KotlinCustomResource(javaResource, DataCollectionRuleAssociationMapper) {
    /**
     * The resource ID of the data collection endpoint that is to be associated.
     */
    public val dataCollectionEndpointId: Output<String>?
        get() = javaResource.dataCollectionEndpointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the data collection rule that is to be associated.
     */
    public val dataCollectionRuleId: Output<String>?
        get() = javaResource.dataCollectionRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the association.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource entity tag (ETag).
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Metadata about the resource
     */
    public val metadata: Output<DataCollectionRuleAssociationResponseMetadata>
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.let({ args0 ->
                dataCollectionRuleAssociationResponseMetadataToKotlin(args0)
            })
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<DataCollectionRuleAssociationProxyOnlyResourceResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                dataCollectionRuleAssociationProxyOnlyResourceResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataCollectionRuleAssociationMapper : ResourceMapper<DataCollectionRuleAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.DataCollectionRuleAssociation::class == javaResource::class

    override fun map(javaResource: Resource): DataCollectionRuleAssociation =
        DataCollectionRuleAssociation(
            javaResource as
                com.pulumi.azurenative.insights.DataCollectionRuleAssociation,
        )
}

/**
 * @see [DataCollectionRuleAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataCollectionRuleAssociation].
 */
public suspend fun dataCollectionRuleAssociation(
    name: String,
    block: suspend DataCollectionRuleAssociationResourceBuilder.() -> Unit,
):
    DataCollectionRuleAssociation {
    val builder = DataCollectionRuleAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataCollectionRuleAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataCollectionRuleAssociation(name: String): DataCollectionRuleAssociation {
    val builder = DataCollectionRuleAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
