@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.LogSettingsResponse
import com.pulumi.azurenative.insights.kotlin.outputs.MetricSettingsResponse
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.insights.kotlin.outputs.LogSettingsResponse.Companion.toKotlin as logSettingsResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.MetricSettingsResponse.Companion.toKotlin as metricSettingsResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DiagnosticSetting].
 */
@PulumiTagMarker
public class DiagnosticSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiagnosticSettingArgs = DiagnosticSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiagnosticSettingArgsBuilder.() -> Unit) {
        val builder = DiagnosticSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DiagnosticSetting {
        val builtJavaResource =
            com.pulumi.azurenative.insights.DiagnosticSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DiagnosticSetting(builtJavaResource)
    }
}

/**
 * The diagnostic setting resource.
 * Azure REST API version: 2021-05-01-preview. Prior API version in Azure Native 1.x: 2017-05-01-preview.
 * ## Example Usage
 * ### Creates or Updates the diagnostic setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnosticSetting = new AzureNative.Insights.DiagnosticSetting("diagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         LogAnalyticsDestinationType = "Dedicated",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.LogSettingsArgs
 *             {
 *                 CategoryGroup = "allLogs",
 *                 Enabled = true,
 *                 RetentionPolicy = new AzureNative.Insights.Inputs.RetentionPolicyArgs
 *                 {
 *                     Days = 0,
 *                     Enabled = false,
 *                 },
 *             },
 *         },
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Metrics = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricSettingsArgs
 *             {
 *                 Category = "WorkflowMetrics",
 *                 Enabled = true,
 *                 RetentionPolicy = new AzureNative.Insights.Inputs.RetentionPolicyArgs
 *                 {
 *                     Days = 0,
 *                     Enabled = false,
 *                 },
 *             },
 *         },
 *         Name = "mysetting",
 *         ResourceUri = "subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1",
 *         WorkspaceId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDiagnosticSetting(ctx, "diagnosticSetting", &insights.DiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			LogAnalyticsDestinationType: pulumi.String("Dedicated"),
 * 			Logs: []insights.LogSettingsArgs{
 * 				{
 * 					CategoryGroup: pulumi.String("allLogs"),
 * 					Enabled:       pulumi.Bool(true),
 * 					RetentionPolicy: {
 * 						Days:    pulumi.Int(0),
 * 						Enabled: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Metrics: []insights.MetricSettingsArgs{
 * 				{
 * 					Category: pulumi.String("WorkflowMetrics"),
 * 					Enabled:  pulumi.Bool(true),
 * 					RetentionPolicy: {
 * 						Days:    pulumi.Int(0),
 * 						Enabled: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			Name:             pulumi.String("mysetting"),
 * 			ResourceUri:      pulumi.String("subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6"),
 * 			StorageAccountId: pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1"),
 * 			WorkspaceId:      pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DiagnosticSetting;
 * import com.pulumi.azurenative.insights.DiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnosticSetting = new DiagnosticSetting("diagnosticSetting", DiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logAnalyticsDestinationType("Dedicated")
 *             .logs(Map.ofEntries(
 *                 Map.entry("categoryGroup", "allLogs"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("days", 0),
 *                     Map.entry("enabled", false)
 *                 ))
 *             ))
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .metrics(Map.ofEntries(
 *                 Map.entry("category", "WorkflowMetrics"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("days", 0),
 *                     Map.entry("enabled", false)
 *                 ))
 *             ))
 *             .name("mysetting")
 *             .resourceUri("subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1")
 *             .workspaceId("")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or Updates the diagnostic setting for category
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnosticSetting = new AzureNative.Insights.DiagnosticSetting("diagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         LogAnalyticsDestinationType = "Dedicated",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.LogSettingsArgs
 *             {
 *                 Category = "WorkflowRuntime",
 *                 Enabled = true,
 *                 RetentionPolicy = new AzureNative.Insights.Inputs.RetentionPolicyArgs
 *                 {
 *                     Days = 0,
 *                     Enabled = false,
 *                 },
 *             },
 *         },
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Metrics = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricSettingsArgs
 *             {
 *                 Category = "WorkflowMetrics",
 *                 Enabled = true,
 *                 RetentionPolicy = new AzureNative.Insights.Inputs.RetentionPolicyArgs
 *                 {
 *                     Days = 0,
 *                     Enabled = false,
 *                 },
 *             },
 *         },
 *         Name = "mysetting",
 *         ResourceUri = "subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1",
 *         WorkspaceId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDiagnosticSetting(ctx, "diagnosticSetting", &insights.DiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			LogAnalyticsDestinationType: pulumi.String("Dedicated"),
 * 			Logs: []insights.LogSettingsArgs{
 * 				{
 * 					Category: pulumi.String("WorkflowRuntime"),
 * 					Enabled:  pulumi.Bool(true),
 * 					RetentionPolicy: {
 * 						Days:    pulumi.Int(0),
 * 						Enabled: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Metrics: []insights.MetricSettingsArgs{
 * 				{
 * 					Category: pulumi.String("WorkflowMetrics"),
 * 					Enabled:  pulumi.Bool(true),
 * 					RetentionPolicy: {
 * 						Days:    pulumi.Int(0),
 * 						Enabled: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			Name:             pulumi.String("mysetting"),
 * 			ResourceUri:      pulumi.String("subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6"),
 * 			StorageAccountId: pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1"),
 * 			WorkspaceId:      pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DiagnosticSetting;
 * import com.pulumi.azurenative.insights.DiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnosticSetting = new DiagnosticSetting("diagnosticSetting", DiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logAnalyticsDestinationType("Dedicated")
 *             .logs(Map.ofEntries(
 *                 Map.entry("category", "WorkflowRuntime"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("days", 0),
 *                     Map.entry("enabled", false)
 *                 ))
 *             ))
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .metrics(Map.ofEntries(
 *                 Map.entry("category", "WorkflowMetrics"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("days", 0),
 *                     Map.entry("enabled", false)
 *                 ))
 *             ))
 *             .name("mysetting")
 *             .resourceUri("subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1")
 *             .workspaceId("")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:DiagnosticSetting mysetting /{resourceUri}/providers/Microsoft.Insights/diagnosticSettings/{name}
 * ```
 */
public class DiagnosticSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.DiagnosticSetting,
) : KotlinCustomResource(javaResource, DiagnosticSettingMapper) {
    /**
     * The resource Id for the event hub authorization rule.
     */
    public val eventHubAuthorizationRuleId: Output<String>?
        get() = javaResource.eventHubAuthorizationRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the event hub. If none is specified, the default event hub will be selected.
     */
    public val eventHubName: Output<String>?
        get() = javaResource.eventHubName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A string indicating whether the export to Log Analytics should use the default destination type, i.e. AzureDiagnostics, or use a destination type constructed as follows: <normalized service identity>_<normalized category name>. Possible values are: Dedicated and null (null is default.)
     */
    public val logAnalyticsDestinationType: Output<String>?
        get() = javaResource.logAnalyticsDestinationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of logs settings.
     */
    public val logs: Output<List<LogSettingsResponse>>?
        get() = javaResource.logs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> logSettingsResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
     */
    public val marketplacePartnerId: Output<String>?
        get() = javaResource.marketplacePartnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of metric settings.
     */
    public val metrics: Output<List<MetricSettingsResponse>>?
        get() = javaResource.metrics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> metricSettingsResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    public val serviceBusRuleId: Output<String>?
        get() = javaResource.serviceBusRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    public val storageAccountId: Output<String>?
        get() = javaResource.storageAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    public val workspaceId: Output<String>?
        get() = javaResource.workspaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DiagnosticSettingMapper : ResourceMapper<DiagnosticSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.DiagnosticSetting::class == javaResource::class

    override fun map(javaResource: Resource): DiagnosticSetting = DiagnosticSetting(
        javaResource as
            com.pulumi.azurenative.insights.DiagnosticSetting,
    )
}

/**
 * @see [DiagnosticSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DiagnosticSetting].
 */
public suspend fun diagnosticSetting(
    name: String,
    block: suspend DiagnosticSettingResourceBuilder.() -> Unit,
): DiagnosticSetting {
    val builder = DiagnosticSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DiagnosticSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diagnosticSetting(name: String): DiagnosticSetting {
    val builder = DiagnosticSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
