@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Virtual machine guest diagnostic settings resource.
 * Azure REST API version: 2018-06-01-preview. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * ## Example Usage
 * ### Create or update an guest diagnostic settings association
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestDiagnosticsSettingsAssociation = new AzureNative.Insights.GuestDiagnosticsSettingsAssociation("guestDiagnosticsSettingsAssociation", new()
 *     {
 *         AssociationName = "healthSystemMachineConfigAssociation",
 *         GuestDiagnosticSettingsName = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-Association-ResourceGroup/providers/providers/microsoft.insights/guestDiagnosticSettings/vmSettingForSecurity",
 *         Location = "Global",
 *         ResourceUri = "subscriptions/8498f01b-8064-4e37-856e-318f3c6c685f/resourceGroups/healthsystem/providers/Microsoft.Compute/virtualMachines/eastussojai",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewGuestDiagnosticsSettingsAssociation(ctx, "guestDiagnosticsSettingsAssociation", &insights.GuestDiagnosticsSettingsAssociationArgs{
 * 			AssociationName:             pulumi.String("healthSystemMachineConfigAssociation"),
 * 			GuestDiagnosticSettingsName: pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-Association-ResourceGroup/providers/providers/microsoft.insights/guestDiagnosticSettings/vmSettingForSecurity"),
 * 			Location:                    pulumi.String("Global"),
 * 			ResourceUri:                 pulumi.String("subscriptions/8498f01b-8064-4e37-856e-318f3c6c685f/resourceGroups/healthsystem/providers/Microsoft.Compute/virtualMachines/eastussojai"),
 * 			Tags:                        nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociation;
 * import com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestDiagnosticsSettingsAssociation = new GuestDiagnosticsSettingsAssociation("guestDiagnosticsSettingsAssociation", GuestDiagnosticsSettingsAssociationArgs.builder()
 *             .associationName("healthSystemMachineConfigAssociation")
 *             .guestDiagnosticSettingsName("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-Association-ResourceGroup/providers/providers/microsoft.insights/guestDiagnosticSettings/vmSettingForSecurity")
 *             .location("Global")
 *             .resourceUri("subscriptions/8498f01b-8064-4e37-856e-318f3c6c685f/resourceGroups/healthsystem/providers/Microsoft.Compute/virtualMachines/eastussojai")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:GuestDiagnosticsSettingsAssociation healthSystemMachineConfigAssociation /{resourceUri}/providers/microsoft.insights/guestDiagnosticSettingsAssociation/{associationName}
 * ```
 * @property associationName The name of the diagnostic settings association.
 * @property guestDiagnosticSettingsName The guest diagnostic settings name.
 * @property location Resource location
 * @property resourceUri The fully qualified ID of the resource, including the resource name and resource type.
 * @property tags Resource tags
 */
public data class GuestDiagnosticsSettingsAssociationArgs(
    public val associationName: Output<String>? = null,
    public val guestDiagnosticSettingsName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociationArgs =
        com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociationArgs.builder()
            .associationName(associationName?.applyValue({ args0 -> args0 }))
            .guestDiagnosticSettingsName(guestDiagnosticSettingsName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GuestDiagnosticsSettingsAssociationArgs].
 */
@PulumiTagMarker
public class GuestDiagnosticsSettingsAssociationArgsBuilder internal constructor() {
    private var associationName: Output<String>? = null

    private var guestDiagnosticSettingsName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceUri: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the diagnostic settings association.
     */
    @JvmName("exjucjjxtqvmxvlb")
    public suspend fun associationName(`value`: Output<String>) {
        this.associationName = value
    }

    /**
     * @param value The guest diagnostic settings name.
     */
    @JvmName("mcorukomwkxdcybo")
    public suspend fun guestDiagnosticSettingsName(`value`: Output<String>) {
        this.guestDiagnosticSettingsName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("jtcfqrxdrlkajvky")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The fully qualified ID of the resource, including the resource name and resource type.
     */
    @JvmName("suucsiknjwjsyeng")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("maqwvqjuywaqvses")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the diagnostic settings association.
     */
    @JvmName("gmcrvoewiddjleye")
    public suspend fun associationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationName = mapped
    }

    /**
     * @param value The guest diagnostic settings name.
     */
    @JvmName("ufruetedyaikssuk")
    public suspend fun guestDiagnosticSettingsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestDiagnosticSettingsName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("culdvhawnpcepnjb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The fully qualified ID of the resource, including the resource name and resource type.
     */
    @JvmName("cjmsgbyapteicpjw")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("wwijxovvydsaklcn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("jncpvpvvoofatpiu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GuestDiagnosticsSettingsAssociationArgs =
        GuestDiagnosticsSettingsAssociationArgs(
            associationName = associationName,
            guestDiagnosticSettingsName = guestDiagnosticSettingsName,
            location = location,
            resourceUri = resourceUri,
            tags = tags,
        )
}
