@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.ManagementGroupDiagnosticSettingArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.ManagementGroupLogSettingsArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ManagementGroupLogSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The management group diagnostic setting resource.
 * Azure REST API version: 2021-05-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * Other available API versions: 2020-01-01-preview.
 * ## Example Usage
 * ### Creates or Updates the management group diagnostic setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementGroupDiagnosticSetting = new AzureNative.Insights.ManagementGroupDiagnosticSetting("managementGroupDiagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.ManagementGroupLogSettingsArgs
 *             {
 *                 CategoryGroup = "allLogs",
 *                 Enabled = true,
 *             },
 *         },
 *         ManagementGroupId = "testChildMG7",
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Name = "setting1",
 *         StorageAccountId = "/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5",
 *         WorkspaceId = "/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewManagementGroupDiagnosticSetting(ctx, "managementGroupDiagnosticSetting", &insights.ManagementGroupDiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			Logs: []insights.ManagementGroupLogSettingsArgs{
 * 				{
 * 					CategoryGroup: pulumi.String("allLogs"),
 * 					Enabled:       pulumi.Bool(true),
 * 				},
 * 			},
 * 			ManagementGroupId:    pulumi.String("testChildMG7"),
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Name:                 pulumi.String("setting1"),
 * 			StorageAccountId:     pulumi.String("/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5"),
 * 			WorkspaceId:          pulumi.String("/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ManagementGroupDiagnosticSetting;
 * import com.pulumi.azurenative.insights.ManagementGroupDiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementGroupDiagnosticSetting = new ManagementGroupDiagnosticSetting("managementGroupDiagnosticSetting", ManagementGroupDiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logs(Map.ofEntries(
 *                 Map.entry("categoryGroup", "allLogs"),
 *                 Map.entry("enabled", true)
 *             ))
 *             .managementGroupId("testChildMG7")
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .name("setting1")
 *             .storageAccountId("/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5")
 *             .workspaceId("/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or Updates the management group diagnostic setting for category
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementGroupDiagnosticSetting = new AzureNative.Insights.ManagementGroupDiagnosticSetting("managementGroupDiagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.ManagementGroupLogSettingsArgs
 *             {
 *                 Category = "Administrative",
 *                 Enabled = true,
 *             },
 *             new AzureNative.Insights.Inputs.ManagementGroupLogSettingsArgs
 *             {
 *                 Category = "Policy",
 *                 Enabled = true,
 *             },
 *         },
 *         ManagementGroupId = "testChildMG7",
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Name = "setting1",
 *         StorageAccountId = "/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5",
 *         WorkspaceId = "/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewManagementGroupDiagnosticSetting(ctx, "managementGroupDiagnosticSetting", &insights.ManagementGroupDiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			Logs: []insights.ManagementGroupLogSettingsArgs{
 * 				{
 * 					Category: pulumi.String("Administrative"),
 * 					Enabled:  pulumi.Bool(true),
 * 				},
 * 				{
 * 					Category: pulumi.String("Policy"),
 * 					Enabled:  pulumi.Bool(true),
 * 				},
 * 			},
 * 			ManagementGroupId:    pulumi.String("testChildMG7"),
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Name:                 pulumi.String("setting1"),
 * 			StorageAccountId:     pulumi.String("/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5"),
 * 			WorkspaceId:          pulumi.String("/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ManagementGroupDiagnosticSetting;
 * import com.pulumi.azurenative.insights.ManagementGroupDiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementGroupDiagnosticSetting = new ManagementGroupDiagnosticSetting("managementGroupDiagnosticSetting", ManagementGroupDiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logs(
 *                 Map.ofEntries(
 *                     Map.entry("category", "Administrative"),
 *                     Map.entry("enabled", true)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("category", "Policy"),
 *                     Map.entry("enabled", true)
 *                 ))
 *             .managementGroupId("testChildMG7")
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .name("setting1")
 *             .storageAccountId("/subscriptions/bfaef57f-297e-4210-bfe5-27c18cc671f7/resourceGroups/FuncAppRunners/providers/Microsoft.Storage/storageAccounts/testpersonalb6a5")
 *             .workspaceId("/subscriptions/9cf7cc0a-0ba1-4624-bc82-97e1ee25dc45/resourceGroups/mgTest/providers/Microsoft.OperationalInsights/workspaces/mgTestWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ManagementGroupDiagnosticSetting setting1 /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Insights/diagnosticSettings/{name}
 * ```
 * @property eventHubAuthorizationRuleId The resource Id for the event hub authorization rule.
 * @property eventHubName The name of the event hub. If none is specified, the default event hub will be selected.
 * @property logs The list of logs settings.
 * @property managementGroupId The management group id.
 * @property marketplacePartnerId The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
 * @property name The name of the diagnostic setting.
 * @property serviceBusRuleId The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
 * @property storageAccountId The resource ID of the storage account to which you would like to send Diagnostic Logs.
 * @property workspaceId The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
 */
public data class ManagementGroupDiagnosticSettingArgs(
    public val eventHubAuthorizationRuleId: Output<String>? = null,
    public val eventHubName: Output<String>? = null,
    public val logs: Output<List<ManagementGroupLogSettingsArgs>>? = null,
    public val managementGroupId: Output<String>? = null,
    public val marketplacePartnerId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val serviceBusRuleId: Output<String>? = null,
    public val storageAccountId: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.ManagementGroupDiagnosticSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.ManagementGroupDiagnosticSettingArgs =
        com.pulumi.azurenative.insights.ManagementGroupDiagnosticSettingArgs.builder()
            .eventHubAuthorizationRuleId(eventHubAuthorizationRuleId?.applyValue({ args0 -> args0 }))
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .logs(logs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .managementGroupId(managementGroupId?.applyValue({ args0 -> args0 }))
            .marketplacePartnerId(marketplacePartnerId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .serviceBusRuleId(serviceBusRuleId?.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementGroupDiagnosticSettingArgs].
 */
@PulumiTagMarker
public class ManagementGroupDiagnosticSettingArgsBuilder internal constructor() {
    private var eventHubAuthorizationRuleId: Output<String>? = null

    private var eventHubName: Output<String>? = null

    private var logs: Output<List<ManagementGroupLogSettingsArgs>>? = null

    private var managementGroupId: Output<String>? = null

    private var marketplacePartnerId: Output<String>? = null

    private var name: Output<String>? = null

    private var serviceBusRuleId: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The resource Id for the event hub authorization rule.
     */
    @JvmName("dawdrpfdxyulopkh")
    public suspend fun eventHubAuthorizationRuleId(`value`: Output<String>) {
        this.eventHubAuthorizationRuleId = value
    }

    /**
     * @param value The name of the event hub. If none is specified, the default event hub will be selected.
     */
    @JvmName("dntegfmbddlfvxsh")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value The list of logs settings.
     */
    @JvmName("ljkhddjkkwutvuis")
    public suspend fun logs(`value`: Output<List<ManagementGroupLogSettingsArgs>>) {
        this.logs = value
    }

    @JvmName("xcrpmjfqijsgemqk")
    public suspend fun logs(vararg values: Output<ManagementGroupLogSettingsArgs>) {
        this.logs = Output.all(values.asList())
    }

    /**
     * @param values The list of logs settings.
     */
    @JvmName("qqbtkehevrdlrewf")
    public suspend fun logs(values: List<Output<ManagementGroupLogSettingsArgs>>) {
        this.logs = Output.all(values)
    }

    /**
     * @param value The management group id.
     */
    @JvmName("tisyeuvlnabwrpnc")
    public suspend fun managementGroupId(`value`: Output<String>) {
        this.managementGroupId = value
    }

    /**
     * @param value The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
     */
    @JvmName("jpaujysuwfvhukmv")
    public suspend fun marketplacePartnerId(`value`: Output<String>) {
        this.marketplacePartnerId = value
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("nhmoibfyixqofhvx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    @JvmName("weougyonyisektun")
    public suspend fun serviceBusRuleId(`value`: Output<String>) {
        this.serviceBusRuleId = value
    }

    /**
     * @param value The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    @JvmName("yfrfehvyxcagbphx")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    @JvmName("rccifiabhmgjcgck")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The resource Id for the event hub authorization rule.
     */
    @JvmName("mvrbqyrttmoailpu")
    public suspend fun eventHubAuthorizationRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubAuthorizationRuleId = mapped
    }

    /**
     * @param value The name of the event hub. If none is specified, the default event hub will be selected.
     */
    @JvmName("lfmrfonvhoxmoarm")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value The list of logs settings.
     */
    @JvmName("nlkorveaktfeiqqb")
    public suspend fun logs(`value`: List<ManagementGroupLogSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("nqmxgfsbpcibuvkx")
    public suspend
    fun logs(argument: List<suspend ManagementGroupLogSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagementGroupLogSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("pgeymwkbqitnufmr")
    public suspend fun logs(
        vararg
        argument: suspend ManagementGroupLogSettingsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ManagementGroupLogSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("nxrlfcgjdkltjyhm")
    public suspend fun logs(argument: suspend ManagementGroupLogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagementGroupLogSettingsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param values The list of logs settings.
     */
    @JvmName("scqccearrprelscj")
    public suspend fun logs(vararg values: ManagementGroupLogSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param value The management group id.
     */
    @JvmName("frujbnxnfvlycncx")
    public suspend fun managementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroupId = mapped
    }

    /**
     * @param value The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
     */
    @JvmName("ccgfebnaraakejtn")
    public suspend fun marketplacePartnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplacePartnerId = mapped
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("pksbcynfebpylmhe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    @JvmName("cenffpepvebxqjst")
    public suspend fun serviceBusRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusRuleId = mapped
    }

    /**
     * @param value The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    @JvmName("doyfjvbmmoscjqsj")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    @JvmName("iqalueuytvukusqr")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): ManagementGroupDiagnosticSettingArgs = ManagementGroupDiagnosticSettingArgs(
        eventHubAuthorizationRuleId = eventHubAuthorizationRuleId,
        eventHubName = eventHubName,
        logs = logs,
        managementGroupId = managementGroupId,
        marketplacePartnerId = marketplacePartnerId,
        name = name,
        serviceBusRuleId = serviceBusRuleId,
        storageAccountId = storageAccountId,
        workspaceId = workspaceId,
    )
}
