@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.SubscriptionLogSettingsResponse
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.insights.kotlin.outputs.SubscriptionLogSettingsResponse.Companion.toKotlin as subscriptionLogSettingsResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SubscriptionDiagnosticSetting].
 */
@PulumiTagMarker
public class SubscriptionDiagnosticSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubscriptionDiagnosticSettingArgs = SubscriptionDiagnosticSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubscriptionDiagnosticSettingArgsBuilder.() -> Unit) {
        val builder = SubscriptionDiagnosticSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SubscriptionDiagnosticSetting {
        val builtJavaResource =
            com.pulumi.azurenative.insights.SubscriptionDiagnosticSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SubscriptionDiagnosticSetting(builtJavaResource)
    }
}

/**
 * The subscription diagnostic setting resource.
 * Azure REST API version: 2021-05-01-preview. Prior API version in Azure Native 1.x: 2017-05-01-preview.
 * Other available API versions: 2017-05-01-preview.
 * ## Example Usage
 * ### Creates or Updates the subscription diagnostic setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscriptionDiagnosticSetting = new AzureNative.Insights.SubscriptionDiagnosticSetting("subscriptionDiagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.SubscriptionLogSettingsArgs
 *             {
 *                 CategoryGroup = "allLogs",
 *                 Enabled = true,
 *             },
 *         },
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Name = "ds4",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1",
 *         WorkspaceId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewSubscriptionDiagnosticSetting(ctx, "subscriptionDiagnosticSetting", &insights.SubscriptionDiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			Logs: []insights.SubscriptionLogSettingsArgs{
 * 				{
 * 					CategoryGroup: pulumi.String("allLogs"),
 * 					Enabled:       pulumi.Bool(true),
 * 				},
 * 			},
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Name:                 pulumi.String("ds4"),
 * 			StorageAccountId:     pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1"),
 * 			WorkspaceId:          pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.SubscriptionDiagnosticSetting;
 * import com.pulumi.azurenative.insights.SubscriptionDiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscriptionDiagnosticSetting = new SubscriptionDiagnosticSetting("subscriptionDiagnosticSetting", SubscriptionDiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logs(Map.ofEntries(
 *                 Map.entry("categoryGroup", "allLogs"),
 *                 Map.entry("enabled", true)
 *             ))
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .name("ds4")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1")
 *             .workspaceId("")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or Updates the subscription diagnostic setting for category
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscriptionDiagnosticSetting = new AzureNative.Insights.SubscriptionDiagnosticSetting("subscriptionDiagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.SubscriptionLogSettingsArgs
 *             {
 *                 Category = "Security",
 *                 Enabled = true,
 *             },
 *         },
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Name = "ds4",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1",
 *         WorkspaceId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewSubscriptionDiagnosticSetting(ctx, "subscriptionDiagnosticSetting", &insights.SubscriptionDiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			Logs: []insights.SubscriptionLogSettingsArgs{
 * 				{
 * 					Category: pulumi.String("Security"),
 * 					Enabled:  pulumi.Bool(true),
 * 				},
 * 			},
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Name:                 pulumi.String("ds4"),
 * 			StorageAccountId:     pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1"),
 * 			WorkspaceId:          pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.SubscriptionDiagnosticSetting;
 * import com.pulumi.azurenative.insights.SubscriptionDiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscriptionDiagnosticSetting = new SubscriptionDiagnosticSetting("subscriptionDiagnosticSetting", SubscriptionDiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logs(Map.ofEntries(
 *                 Map.entry("category", "Security"),
 *                 Map.entry("enabled", true)
 *             ))
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .name("ds4")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1")
 *             .workspaceId("")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:SubscriptionDiagnosticSetting ds4 /subscriptions/{subscriptionId}/providers/Microsoft.Insights/diagnosticSettings/{name}
 * ```
 */
public class SubscriptionDiagnosticSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.SubscriptionDiagnosticSetting,
) : KotlinCustomResource(javaResource, SubscriptionDiagnosticSettingMapper) {
    /**
     * The resource Id for the event hub authorization rule.
     */
    public val eventHubAuthorizationRuleId: Output<String>?
        get() = javaResource.eventHubAuthorizationRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the event hub. If none is specified, the default event hub will be selected.
     */
    public val eventHubName: Output<String>?
        get() = javaResource.eventHubName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of logs settings.
     */
    public val logs: Output<List<SubscriptionLogSettingsResponse>>?
        get() = javaResource.logs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> subscriptionLogSettingsResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
     */
    public val marketplacePartnerId: Output<String>?
        get() = javaResource.marketplacePartnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    public val serviceBusRuleId: Output<String>?
        get() = javaResource.serviceBusRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    public val storageAccountId: Output<String>?
        get() = javaResource.storageAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    public val workspaceId: Output<String>?
        get() = javaResource.workspaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SubscriptionDiagnosticSettingMapper : ResourceMapper<SubscriptionDiagnosticSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.SubscriptionDiagnosticSetting::class == javaResource::class

    override fun map(javaResource: Resource): SubscriptionDiagnosticSetting =
        SubscriptionDiagnosticSetting(
            javaResource as
                com.pulumi.azurenative.insights.SubscriptionDiagnosticSetting,
        )
}

/**
 * @see [SubscriptionDiagnosticSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SubscriptionDiagnosticSetting].
 */
public suspend fun subscriptionDiagnosticSetting(
    name: String,
    block: suspend SubscriptionDiagnosticSettingResourceBuilder.() -> Unit,
):
    SubscriptionDiagnosticSetting {
    val builder = SubscriptionDiagnosticSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SubscriptionDiagnosticSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subscriptionDiagnosticSetting(name: String): SubscriptionDiagnosticSetting {
    val builder = SubscriptionDiagnosticSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
