@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.WorkbookArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.WorkbookSharedTypeKind
import com.pulumi.azurenative.insights.kotlin.inputs.WorkbookResourceIdentityArgs
import com.pulumi.azurenative.insights.kotlin.inputs.WorkbookResourceIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A workbook definition.
 * Azure REST API version: 2022-04-01. Prior API version in Azure Native 1.x: 2020-10-20.
 * Other available API versions: 2015-05-01, 2021-03-08, 2021-08-01, 2023-06-01.
 * ## Example Usage
 * ### WorkbookAdd
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workbook = new AzureNative.Insights.Workbook("workbook", new()
 *     {
 *         Category = "workbook",
 *         Description = "Sample workbook",
 *         DisplayName = "Sample workbook",
 *         Kind = "shared",
 *         Location = "westus",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "deadb33f-5e0d-4064-8ebb-1a4ed0313eb2",
 *         SerializedData = "{\"version\":\"Notebook/1.0\",\"items\":[{\"type\":1,\"content\":\"{\"json\":\"## New workbook\\r\\n---\\r\\n\\r\\nWelcome to your new workbook.  This area will display text formatted as markdown.\\r\\n\\r\\n\\r\\nWe've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.\"}\",\"halfWidth\":null,\"conditionalVisibility\":null},{\"type\":3,\"content\":\"{\"version\":\"KqlItem/1.0\",\"query\":\"union withsource=TableName *\\n| summarize Count=count() by TableName\\n| render barchart\",\"showQuery\":false,\"size\":1,\"aggregation\":0,\"showAnnotations\":false}\",\"halfWidth\":null,\"conditionalVisibility\":null}],\"isLocked\":false}",
 *         SourceId = "/subscriptions/6b643656-33eb-422f-aee8-3ac145d124af/resourcegroups/my-resource-group",
 *         Tags =
 *         {
 *             { "TagSample01", "sample01" },
 *             { "TagSample02", "sample02" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewWorkbook(ctx, "workbook", &insights.WorkbookArgs{
 * 			Category:          pulumi.String("workbook"),
 * 			Description:       pulumi.String("Sample workbook"),
 * 			DisplayName:       pulumi.String("Sample workbook"),
 * 			Kind:              pulumi.String("shared"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("deadb33f-5e0d-4064-8ebb-1a4ed0313eb2"),
 * 			SerializedData:    pulumi.String("{\"version\":\"Notebook/1.0\",\"items\":[{\"type\":1,\"content\":\"{\"json\":\"## New workbook\\r\\n---\\r\\n\\r\\nWelcome to your new workbook.  This area will display text formatted as markdown.\\r\\n\\r\\n\\r\\nWe've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.\"}\",\"halfWidth\":null,\"conditionalVisibility\":null},{\"type\":3,\"content\":\"{\"version\":\"KqlItem/1.0\",\"query\":\"union withsource=TableName *\\n| summarize Count=count() by TableName\\n| render barchart\",\"showQuery\":false,\"size\":1,\"aggregation\":0,\"showAnnotations\":false}\",\"halfWidth\":null,\"conditionalVisibility\":null}],\"isLocked\":false}"),
 * 			SourceId:          pulumi.String("/subscriptions/6b643656-33eb-422f-aee8-3ac145d124af/resourcegroups/my-resource-group"),
 * 			Tags: pulumi.StringMap{
 * 				"TagSample01": pulumi.String("sample01"),
 * 				"TagSample02": pulumi.String("sample02"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.Workbook;
 * import com.pulumi.azurenative.insights.WorkbookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workbook = new Workbook("workbook", WorkbookArgs.builder()
 *             .category("workbook")
 *             .description("Sample workbook")
 *             .displayName("Sample workbook")
 *             .kind("shared")
 *             .location("westus")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("deadb33f-5e0d-4064-8ebb-1a4ed0313eb2")
 *             .serializedData("{\"version\":\"Notebook/1.0\",\"items\":[{\"type\":1,\"content\":\"{\"json\":\"## New workbook\\r\\n---\\r\\n\\r\\nWelcome to your new workbook.  This area will display text formatted as markdown.\\r\\n\\r\\n\\r\\nWe've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.\"}\",\"halfWidth\":null,\"conditionalVisibility\":null},{\"type\":3,\"content\":\"{\"version\":\"KqlItem/1.0\",\"query\":\"union withsource=TableName *\\n| summarize Count=count() by TableName\\n| render barchart\",\"showQuery\":false,\"size\":1,\"aggregation\":0,\"showAnnotations\":false}\",\"halfWidth\":null,\"conditionalVisibility\":null}],\"isLocked\":false}")
 *             .sourceId("/subscriptions/6b643656-33eb-422f-aee8-3ac145d124af/resourcegroups/my-resource-group")
 *             .tags(Map.ofEntries(
 *                 Map.entry("TagSample01", "sample01"),
 *                 Map.entry("TagSample02", "sample02")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:Workbook deadb33f-5e0d-4064-8ebb-1a4ed0313eb2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/workbooks/{resourceName}
 * ```
 * @property category Workbook category, as defined by the user at creation time.
 * @property description The description of the workbook.
 * @property displayName The user-defined name (display name) of the workbook.
 * @property identity Identity used for BYOS
 * @property kind The kind of workbook. Only valid value is shared.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the resource.
 * @property serializedData Configuration of this particular workbook. Configuration data is a string containing valid JSON
 * @property sourceId ResourceId for a source resource.
 * @property storageUri The resourceId to the storage account when bring your own storage is used
 * @property tags Resource tags.
 * @property version Workbook schema version format, like 'Notebook/1.0', which should match the workbook in serializedData
 */
public data class WorkbookArgs(
    public val category: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val identity: Output<WorkbookResourceIdentityArgs>? = null,
    public val kind: Output<Either<String, WorkbookSharedTypeKind>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val serializedData: Output<String>? = null,
    public val sourceId: Output<String>? = null,
    public val storageUri: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.WorkbookArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.WorkbookArgs =
        com.pulumi.azurenative.insights.WorkbookArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .serializedData(serializedData?.applyValue({ args0 -> args0 }))
            .sourceId(sourceId?.applyValue({ args0 -> args0 }))
            .storageUri(storageUri?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkbookArgs].
 */
@PulumiTagMarker
public class WorkbookArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var identity: Output<WorkbookResourceIdentityArgs>? = null

    private var kind: Output<Either<String, WorkbookSharedTypeKind>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var serializedData: Output<String>? = null

    private var sourceId: Output<String>? = null

    private var storageUri: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Workbook category, as defined by the user at creation time.
     */
    @JvmName("qetnqhfrgtkccxbq")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The description of the workbook.
     */
    @JvmName("tnfrlvujrdretdcp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The user-defined name (display name) of the workbook.
     */
    @JvmName("trhcujnrxwiaalln")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Identity used for BYOS
     */
    @JvmName("otpiyiptqdacqmbn")
    public suspend fun identity(`value`: Output<WorkbookResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of workbook. Only valid value is shared.
     */
    @JvmName("ygktnkyydwlxsmxp")
    public suspend fun kind(`value`: Output<Either<String, WorkbookSharedTypeKind>>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("eixfhmtqdhprqwrt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("goowknwcaihrupjp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("mebmpmpgtrixgqyy")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Configuration of this particular workbook. Configuration data is a string containing valid JSON
     */
    @JvmName("fsvosrewpsjuqybn")
    public suspend fun serializedData(`value`: Output<String>) {
        this.serializedData = value
    }

    /**
     * @param value ResourceId for a source resource.
     */
    @JvmName("wldesqadfdxqllyn")
    public suspend fun sourceId(`value`: Output<String>) {
        this.sourceId = value
    }

    /**
     * @param value The resourceId to the storage account when bring your own storage is used
     */
    @JvmName("roegduvtewhhrqqx")
    public suspend fun storageUri(`value`: Output<String>) {
        this.storageUri = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("unohyqhraieorydq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Workbook schema version format, like 'Notebook/1.0', which should match the workbook in serializedData
     */
    @JvmName("xuleyutcqikclaap")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Workbook category, as defined by the user at creation time.
     */
    @JvmName("vybsurfldegpndeb")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The description of the workbook.
     */
    @JvmName("ckhjoeqjuckbnjts")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The user-defined name (display name) of the workbook.
     */
    @JvmName("raglbuafucelnqgg")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Identity used for BYOS
     */
    @JvmName("monhoucuuldchetp")
    public suspend fun identity(`value`: WorkbookResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity used for BYOS
     */
    @JvmName("hqggcwkllpbfjako")
    public suspend fun identity(argument: suspend WorkbookResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = WorkbookResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of workbook. Only valid value is shared.
     */
    @JvmName("xviwefpmnfyxtonm")
    public suspend fun kind(`value`: Either<String, WorkbookSharedTypeKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of workbook. Only valid value is shared.
     */
    @JvmName("tdqfewtroeqirsgy")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkbookSharedTypeKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of workbook. Only valid value is shared.
     */
    @JvmName("knugxtvwwmtbqqcj")
    public fun kind(`value`: WorkbookSharedTypeKind) {
        val toBeMapped = Either.ofRight<String, WorkbookSharedTypeKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rwpsomtsykhthoft")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("byysvxdyxhmbcads")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("sdancbifbxpevnyb")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Configuration of this particular workbook. Configuration data is a string containing valid JSON
     */
    @JvmName("gotsspluoxsybmdq")
    public suspend fun serializedData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serializedData = mapped
    }

    /**
     * @param value ResourceId for a source resource.
     */
    @JvmName("piccnnvqjkkdjicr")
    public suspend fun sourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceId = mapped
    }

    /**
     * @param value The resourceId to the storage account when bring your own storage is used
     */
    @JvmName("euljadruuhmgovfo")
    public suspend fun storageUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageUri = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("apboyulkmojchmlm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xrlrbpuahsmhnffn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Workbook schema version format, like 'Notebook/1.0', which should match the workbook in serializedData
     */
    @JvmName("dkepydvnmmfxydro")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): WorkbookArgs = WorkbookArgs(
        category = category,
        description = description,
        displayName = displayName,
        identity = identity,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        serializedData = serializedData,
        sourceId = sourceId,
        storageUri = storageUri,
        tags = tags,
        version = version,
    )
}
