@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The operator used to compare the metric value against the threshold.
 */
public enum class DynamicThresholdOperator(
    public val javaValue: com.pulumi.azurenative.insights.enums.DynamicThresholdOperator,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.DynamicThresholdOperator> {
    GreaterThan(com.pulumi.azurenative.insights.enums.DynamicThresholdOperator.GreaterThan),
    LessThan(com.pulumi.azurenative.insights.enums.DynamicThresholdOperator.LessThan),
    GreaterOrLessThan(com.pulumi.azurenative.insights.enums.DynamicThresholdOperator.GreaterOrLessThan),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.DynamicThresholdOperator = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.DynamicThresholdOperator):
            DynamicThresholdOperator =
            DynamicThresholdOperator.values().first { it.javaValue == javaType }
    }
}
