@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
 */
public enum class DynamicThresholdSensitivity(
    public val javaValue: com.pulumi.azurenative.insights.enums.DynamicThresholdSensitivity,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.DynamicThresholdSensitivity> {
    Low(com.pulumi.azurenative.insights.enums.DynamicThresholdSensitivity.Low),
    Medium(com.pulumi.azurenative.insights.enums.DynamicThresholdSensitivity.Medium),
    High(com.pulumi.azurenative.insights.enums.DynamicThresholdSensitivity.High),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.DynamicThresholdSensitivity =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.DynamicThresholdSensitivity):
            DynamicThresholdSensitivity =
            DynamicThresholdSensitivity.values().first { it.javaValue == javaType }
    }
}
