@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates the flow of the ingestion.
 */
public enum class IngestionMode(
    public val javaValue: com.pulumi.azurenative.insights.enums.IngestionMode,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.IngestionMode> {
    ApplicationInsights(com.pulumi.azurenative.insights.enums.IngestionMode.ApplicationInsights),
    ApplicationInsightsWithDiagnosticSettings(com.pulumi.azurenative.insights.enums.IngestionMode.ApplicationInsightsWithDiagnosticSettings),
    LogAnalytics(com.pulumi.azurenative.insights.enums.IngestionMode.LogAnalytics),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.IngestionMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.IngestionMode):
            IngestionMode = IngestionMode.values().first { it.javaValue == javaType }
    }
}
