@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates the type of scheduled query rule. The default is LogAlert.
 */
public enum class Kind(
    public val javaValue: com.pulumi.azurenative.insights.enums.Kind,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.Kind> {
    LogAlert(com.pulumi.azurenative.insights.enums.Kind.LogAlert),
    LogToMetric(com.pulumi.azurenative.insights.enums.Kind.LogToMetric),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.Kind = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.Kind): Kind =
            Kind.values().first { it.javaValue == javaType }
    }
}
