@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The network access type for accessing Application Insights query.
 */
public enum class PublicNetworkAccessType(
    public val javaValue: com.pulumi.azurenative.insights.enums.PublicNetworkAccessType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.PublicNetworkAccessType> {
    /**
     * Enables connectivity to Application Insights through public DNS.
     */
    Enabled(com.pulumi.azurenative.insights.enums.PublicNetworkAccessType.Enabled),

    /**
     * Disables public connectivity to Application Insights through public DNS.
     */
    Disabled(com.pulumi.azurenative.insights.enums.PublicNetworkAccessType.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.PublicNetworkAccessType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.PublicNetworkAccessType):
            PublicNetworkAccessType =
            PublicNetworkAccessType.values().first { it.javaValue == javaType }
    }
}
