@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.AutoscaleNotificationArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.OperationType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Autoscale notification.
 * @property email the email notification.
 * @property operation the operation associated with the notification and its value must be "scale"
 * @property webhooks the collection of webhook notifications.
 */
public data class AutoscaleNotificationArgs(
    public val email: Output<EmailNotificationArgs>? = null,
    public val operation: Output<OperationType>,
    public val webhooks: Output<List<WebhookNotificationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.AutoscaleNotificationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.AutoscaleNotificationArgs =
        com.pulumi.azurenative.insights.inputs.AutoscaleNotificationArgs.builder()
            .email(email?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .operation(operation.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .webhooks(
                webhooks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutoscaleNotificationArgs].
 */
@PulumiTagMarker
public class AutoscaleNotificationArgsBuilder internal constructor() {
    private var email: Output<EmailNotificationArgs>? = null

    private var operation: Output<OperationType>? = null

    private var webhooks: Output<List<WebhookNotificationArgs>>? = null

    /**
     * @param value the email notification.
     */
    @JvmName("qxkbkabdsgiyskfn")
    public suspend fun email(`value`: Output<EmailNotificationArgs>) {
        this.email = value
    }

    /**
     * @param value the operation associated with the notification and its value must be "scale"
     */
    @JvmName("gjhqqtqqawlbdidm")
    public suspend fun operation(`value`: Output<OperationType>) {
        this.operation = value
    }

    /**
     * @param value the collection of webhook notifications.
     */
    @JvmName("jkagkamkwkucxnmu")
    public suspend fun webhooks(`value`: Output<List<WebhookNotificationArgs>>) {
        this.webhooks = value
    }

    @JvmName("cjvwajnfkoyyvcoy")
    public suspend fun webhooks(vararg values: Output<WebhookNotificationArgs>) {
        this.webhooks = Output.all(values.asList())
    }

    /**
     * @param values the collection of webhook notifications.
     */
    @JvmName("ctimsuqwrsosjcly")
    public suspend fun webhooks(values: List<Output<WebhookNotificationArgs>>) {
        this.webhooks = Output.all(values)
    }

    /**
     * @param value the email notification.
     */
    @JvmName("vribompgmgjfxucr")
    public suspend fun email(`value`: EmailNotificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param argument the email notification.
     */
    @JvmName("shetepepkqnolnwn")
    public suspend fun email(argument: suspend EmailNotificationArgsBuilder.() -> Unit) {
        val toBeMapped = EmailNotificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.email = mapped
    }

    /**
     * @param value the operation associated with the notification and its value must be "scale"
     */
    @JvmName("adgdoksukqyimqpv")
    public suspend fun operation(`value`: OperationType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value the collection of webhook notifications.
     */
    @JvmName("uuuflnttbpotyiuh")
    public suspend fun webhooks(`value`: List<WebhookNotificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhooks = mapped
    }

    /**
     * @param argument the collection of webhook notifications.
     */
    @JvmName("nbbetbvdcgfguqyq")
    public suspend fun webhooks(argument: List<suspend WebhookNotificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebhookNotificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.webhooks = mapped
    }

    /**
     * @param argument the collection of webhook notifications.
     */
    @JvmName("xqrmyocolekoqccv")
    public suspend fun webhooks(vararg argument: suspend WebhookNotificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebhookNotificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.webhooks = mapped
    }

    /**
     * @param argument the collection of webhook notifications.
     */
    @JvmName("whyvhouudpljggww")
    public suspend fun webhooks(argument: suspend WebhookNotificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebhookNotificationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.webhooks = mapped
    }

    /**
     * @param values the collection of webhook notifications.
     */
    @JvmName("peujcqqlilevedyg")
    public suspend fun webhooks(vararg values: WebhookNotificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webhooks = mapped
    }

    internal fun build(): AutoscaleNotificationArgs = AutoscaleNotificationArgs(
        email = email,
        operation = operation ?: throw PulumiNullFieldException("operation"),
        webhooks = webhooks,
    )
}
