@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.AzureFunctionReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An azure function receiver.
 * @property functionAppResourceId The azure resource id of the function app.
 * @property functionName The function name in the function app.
 * @property httpTriggerUrl The http trigger url where http request sent to.
 * @property name The name of the azure function receiver. Names must be unique across all receivers within an action group.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class AzureFunctionReceiverArgs(
    public val functionAppResourceId: Output<String>,
    public val functionName: Output<String>,
    public val httpTriggerUrl: Output<String>,
    public val name: Output<String>,
    public val useCommonAlertSchema: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.AzureFunctionReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.AzureFunctionReceiverArgs =
        com.pulumi.azurenative.insights.inputs.AzureFunctionReceiverArgs.builder()
            .functionAppResourceId(functionAppResourceId.applyValue({ args0 -> args0 }))
            .functionName(functionName.applyValue({ args0 -> args0 }))
            .httpTriggerUrl(httpTriggerUrl.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .useCommonAlertSchema(useCommonAlertSchema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFunctionReceiverArgs].
 */
@PulumiTagMarker
public class AzureFunctionReceiverArgsBuilder internal constructor() {
    private var functionAppResourceId: Output<String>? = null

    private var functionName: Output<String>? = null

    private var httpTriggerUrl: Output<String>? = null

    private var name: Output<String>? = null

    private var useCommonAlertSchema: Output<Boolean>? = null

    /**
     * @param value The azure resource id of the function app.
     */
    @JvmName("vmqaaqexfbbcupsc")
    public suspend fun functionAppResourceId(`value`: Output<String>) {
        this.functionAppResourceId = value
    }

    /**
     * @param value The function name in the function app.
     */
    @JvmName("mgpbflmnddkhlihg")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value The http trigger url where http request sent to.
     */
    @JvmName("wndppxdloplokxec")
    public suspend fun httpTriggerUrl(`value`: Output<String>) {
        this.httpTriggerUrl = value
    }

    /**
     * @param value The name of the azure function receiver. Names must be unique across all receivers within an action group.
     */
    @JvmName("ssdolijikkeuatyc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("rkdxdasbxqkhbsps")
    public suspend fun useCommonAlertSchema(`value`: Output<Boolean>) {
        this.useCommonAlertSchema = value
    }

    /**
     * @param value The azure resource id of the function app.
     */
    @JvmName("ydeenvhooktlfban")
    public suspend fun functionAppResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionAppResourceId = mapped
    }

    /**
     * @param value The function name in the function app.
     */
    @JvmName("uwqeccahsnwlneiv")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value The http trigger url where http request sent to.
     */
    @JvmName("whqqeniktbfpwdwu")
    public suspend fun httpTriggerUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpTriggerUrl = mapped
    }

    /**
     * @param value The name of the azure function receiver. Names must be unique across all receivers within an action group.
     */
    @JvmName("fwydqrmmccvofsoc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("ybnrfanensrqchqf")
    public suspend fun useCommonAlertSchema(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCommonAlertSchema = mapped
    }

    internal fun build(): AzureFunctionReceiverArgs = AzureFunctionReceiverArgs(
        functionAppResourceId = functionAppResourceId ?: throw
            PulumiNullFieldException("functionAppResourceId"),
        functionName = functionName ?: throw PulumiNullFieldException("functionName"),
        httpTriggerUrl = httpTriggerUrl ?: throw PulumiNullFieldException("httpTriggerUrl"),
        name = name ?: throw PulumiNullFieldException("name"),
        useCommonAlertSchema = useCommonAlertSchema,
    )
}
