@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DataFlowArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownDataFlowStreams
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Definition of which streams are sent to which destinations.
 * @property builtInTransform The builtIn transform to transform stream data
 * @property destinations List of destinations for this data flow.
 * @property outputStream The output stream of the transform. Only required if the transform changes data to a different stream.
 * @property streams List of streams for this data flow.
 * @property transformKql The KQL query to transform stream data.
 */
public data class DataFlowArgs(
    public val builtInTransform: Output<String>? = null,
    public val destinations: Output<List<String>>? = null,
    public val outputStream: Output<String>? = null,
    public val streams: Output<List<Either<String, KnownDataFlowStreams>>>? = null,
    public val transformKql: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DataFlowArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DataFlowArgs =
        com.pulumi.azurenative.insights.inputs.DataFlowArgs.builder()
            .builtInTransform(builtInTransform?.applyValue({ args0 -> args0 }))
            .destinations(destinations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputStream(outputStream?.applyValue({ args0 -> args0 }))
            .streams(
                streams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .transformKql(transformKql?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataFlowArgs].
 */
@PulumiTagMarker
public class DataFlowArgsBuilder internal constructor() {
    private var builtInTransform: Output<String>? = null

    private var destinations: Output<List<String>>? = null

    private var outputStream: Output<String>? = null

    private var streams: Output<List<Either<String, KnownDataFlowStreams>>>? = null

    private var transformKql: Output<String>? = null

    /**
     * @param value The builtIn transform to transform stream data
     */
    @JvmName("voycfruxjfyhuies")
    public suspend fun builtInTransform(`value`: Output<String>) {
        this.builtInTransform = value
    }

    /**
     * @param value List of destinations for this data flow.
     */
    @JvmName("opogvvunylvoemaq")
    public suspend fun destinations(`value`: Output<List<String>>) {
        this.destinations = value
    }

    @JvmName("ruajmrknrbttcxyp")
    public suspend fun destinations(vararg values: Output<String>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values List of destinations for this data flow.
     */
    @JvmName("qustwqoateronrne")
    public suspend fun destinations(values: List<Output<String>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value The output stream of the transform. Only required if the transform changes data to a different stream.
     */
    @JvmName("btxelafbpncaodxl")
    public suspend fun outputStream(`value`: Output<String>) {
        this.outputStream = value
    }

    /**
     * @param value List of streams for this data flow.
     */
    @JvmName("xdlwudcobacfgaeb")
    public suspend fun streams(`value`: Output<List<Either<String, KnownDataFlowStreams>>>) {
        this.streams = value
    }

    @JvmName("qblrdmojadbgwmwd")
    public suspend fun streams(vararg values: Output<Either<String, KnownDataFlowStreams>>) {
        this.streams = Output.all(values.asList())
    }

    /**
     * @param values List of streams for this data flow.
     */
    @JvmName("mmwlevivxwmkkbfq")
    public suspend fun streams(values: List<Output<Either<String, KnownDataFlowStreams>>>) {
        this.streams = Output.all(values)
    }

    /**
     * @param value The KQL query to transform stream data.
     */
    @JvmName("mlbnglqrwxhacpvq")
    public suspend fun transformKql(`value`: Output<String>) {
        this.transformKql = value
    }

    /**
     * @param value The builtIn transform to transform stream data
     */
    @JvmName("teenkcbwhgpwihrp")
    public suspend fun builtInTransform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.builtInTransform = mapped
    }

    /**
     * @param value List of destinations for this data flow.
     */
    @JvmName("khojlbqvythsxhte")
    public suspend fun destinations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param values List of destinations for this data flow.
     */
    @JvmName("jhidufyknisfjiec")
    public suspend fun destinations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value The output stream of the transform. Only required if the transform changes data to a different stream.
     */
    @JvmName("arjacjsivjosnijn")
    public suspend fun outputStream(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputStream = mapped
    }

    /**
     * @param value List of streams for this data flow.
     */
    @JvmName("nlchmyryjxwjwufx")
    public suspend fun streams(`value`: List<Either<String, KnownDataFlowStreams>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param values List of streams for this data flow.
     */
    @JvmName("luwmflvkrpfghtww")
    public suspend fun streams(vararg values: Either<String, KnownDataFlowStreams>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param value The KQL query to transform stream data.
     */
    @JvmName("pdjjlwjiwwftudtd")
    public suspend fun transformKql(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transformKql = mapped
    }

    internal fun build(): DataFlowArgs = DataFlowArgs(
        builtInTransform = builtInTransform,
        destinations = destinations,
        outputStream = outputStream,
        streams = streams,
        transformKql = transformKql,
    )
}
