@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DataImportSourcesEventHubArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of Event Hub configuration.
 * @property consumerGroup Event Hub consumer group name
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property stream The stream to collect from EventHub
 */
public data class DataImportSourcesEventHubArgs(
    public val consumerGroup: Output<String>? = null,
    public val name: Output<String>? = null,
    public val stream: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DataImportSourcesEventHubArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DataImportSourcesEventHubArgs =
        com.pulumi.azurenative.insights.inputs.DataImportSourcesEventHubArgs.builder()
            .consumerGroup(consumerGroup?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .stream(stream?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataImportSourcesEventHubArgs].
 */
@PulumiTagMarker
public class DataImportSourcesEventHubArgsBuilder internal constructor() {
    private var consumerGroup: Output<String>? = null

    private var name: Output<String>? = null

    private var stream: Output<String>? = null

    /**
     * @param value Event Hub consumer group name
     */
    @JvmName("ibjrvgcslytlpbrs")
    public suspend fun consumerGroup(`value`: Output<String>) {
        this.consumerGroup = value
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("owpxcyiyxriifaka")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The stream to collect from EventHub
     */
    @JvmName("lgecixyvitebymhl")
    public suspend fun stream(`value`: Output<String>) {
        this.stream = value
    }

    /**
     * @param value Event Hub consumer group name
     */
    @JvmName("pmlbmwfjpnpgnxfs")
    public suspend fun consumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroup = mapped
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("qumltuscegncvviv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The stream to collect from EventHub
     */
    @JvmName("gndhhwrtuxdxtars")
    public suspend fun stream(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stream = mapped
    }

    internal fun build(): DataImportSourcesEventHubArgs = DataImportSourcesEventHubArgs(
        consumerGroup = consumerGroup,
        name = name,
        stream = stream,
    )
}
