@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DataSourcesSpecDataImportsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifications of pull based data sources
 * @property eventHub Definition of Event Hub configuration.
 */
public data class DataSourcesSpecDataImportsArgs(
    public val eventHub: Output<DataImportSourcesEventHubArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DataSourcesSpecDataImportsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DataSourcesSpecDataImportsArgs =
        com.pulumi.azurenative.insights.inputs.DataSourcesSpecDataImportsArgs.builder()
            .eventHub(eventHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataSourcesSpecDataImportsArgs].
 */
@PulumiTagMarker
public class DataSourcesSpecDataImportsArgsBuilder internal constructor() {
    private var eventHub: Output<DataImportSourcesEventHubArgs>? = null

    /**
     * @param value Definition of Event Hub configuration.
     */
    @JvmName("ycoxrranycvngsoo")
    public suspend fun eventHub(`value`: Output<DataImportSourcesEventHubArgs>) {
        this.eventHub = value
    }

    /**
     * @param value Definition of Event Hub configuration.
     */
    @JvmName("iqevhwhsodbeiltq")
    public suspend fun eventHub(`value`: DataImportSourcesEventHubArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHub = mapped
    }

    /**
     * @param argument Definition of Event Hub configuration.
     */
    @JvmName("yosjfeakkymhusoj")
    public suspend fun eventHub(argument: suspend DataImportSourcesEventHubArgsBuilder.() -> Unit) {
        val toBeMapped = DataImportSourcesEventHubArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eventHub = mapped
    }

    internal fun build(): DataSourcesSpecDataImportsArgs = DataSourcesSpecDataImportsArgs(
        eventHub = eventHub,
    )
}
