@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DimensionArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.DimensionOperator
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Dimension splitting and filtering definition
 * @property name Name of the dimension
 * @property operator Operator for dimension values
 * @property values List of dimension values
 */
public data class DimensionArgs(
    public val name: Output<String>,
    public val `operator`: Output<Either<String, DimensionOperator>>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DimensionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DimensionArgs =
        com.pulumi.azurenative.insights.inputs.DimensionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DimensionArgs].
 */
@PulumiTagMarker
public class DimensionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `operator`: Output<Either<String, DimensionOperator>>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Name of the dimension
     */
    @JvmName("bqcfmbpmqkrruxmw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Operator for dimension values
     */
    @JvmName("mqgawveuxhcbymfk")
    public suspend fun `operator`(`value`: Output<Either<String, DimensionOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value List of dimension values
     */
    @JvmName("jwbnsystjlrbqnow")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("uwpaqoliotfsgivc")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values List of dimension values
     */
    @JvmName("jdnvsxglfjpxgddb")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Name of the dimension
     */
    @JvmName("ivaflljfubrkintw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Operator for dimension values
     */
    @JvmName("guissgaahcossphs")
    public suspend fun `operator`(`value`: Either<String, DimensionOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Operator for dimension values
     */
    @JvmName("wbblbmtmxfehdluy")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DimensionOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Operator for dimension values
     */
    @JvmName("nhmllnqyesoyvedn")
    public fun `operator`(`value`: DimensionOperator) {
        val toBeMapped = Either.ofRight<String, DimensionOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value List of dimension values
     */
    @JvmName("bqthryjovcunvsxe")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values List of dimension values
     */
    @JvmName("pjigbaspupmqdhwa")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): DimensionArgs = DimensionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
