@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.EmailNotificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Email notification of an autoscale event.
 * @property customEmails the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
 * @property sendToSubscriptionAdministrator a value indicating whether to send email to subscription administrator.
 * @property sendToSubscriptionCoAdministrators a value indicating whether to send email to subscription co-administrators.
 */
public data class EmailNotificationArgs(
    public val customEmails: Output<List<String>>? = null,
    public val sendToSubscriptionAdministrator: Output<Boolean>? = null,
    public val sendToSubscriptionCoAdministrators: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.EmailNotificationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.EmailNotificationArgs =
        com.pulumi.azurenative.insights.inputs.EmailNotificationArgs.builder()
            .customEmails(customEmails?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sendToSubscriptionAdministrator(sendToSubscriptionAdministrator?.applyValue({ args0 -> args0 }))
            .sendToSubscriptionCoAdministrators(
                sendToSubscriptionCoAdministrators?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [EmailNotificationArgs].
 */
@PulumiTagMarker
public class EmailNotificationArgsBuilder internal constructor() {
    private var customEmails: Output<List<String>>? = null

    private var sendToSubscriptionAdministrator: Output<Boolean>? = null

    private var sendToSubscriptionCoAdministrators: Output<Boolean>? = null

    /**
     * @param value the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
     */
    @JvmName("xnjnxkdrmexkbivd")
    public suspend fun customEmails(`value`: Output<List<String>>) {
        this.customEmails = value
    }

    @JvmName("ifqlowcxjlkqqdua")
    public suspend fun customEmails(vararg values: Output<String>) {
        this.customEmails = Output.all(values.asList())
    }

    /**
     * @param values the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
     */
    @JvmName("bbdowbwbpnctkcpg")
    public suspend fun customEmails(values: List<Output<String>>) {
        this.customEmails = Output.all(values)
    }

    /**
     * @param value a value indicating whether to send email to subscription administrator.
     */
    @JvmName("jlqrlyrqsixvolrk")
    public suspend fun sendToSubscriptionAdministrator(`value`: Output<Boolean>) {
        this.sendToSubscriptionAdministrator = value
    }

    /**
     * @param value a value indicating whether to send email to subscription co-administrators.
     */
    @JvmName("gvbqplbvmxtomffk")
    public suspend fun sendToSubscriptionCoAdministrators(`value`: Output<Boolean>) {
        this.sendToSubscriptionCoAdministrators = value
    }

    /**
     * @param value the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
     */
    @JvmName("rjygkohwhcmyokgf")
    public suspend fun customEmails(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEmails = mapped
    }

    /**
     * @param values the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
     */
    @JvmName("uekkqcepjrlrinqv")
    public suspend fun customEmails(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customEmails = mapped
    }

    /**
     * @param value a value indicating whether to send email to subscription administrator.
     */
    @JvmName("hygsngfbqkiocemw")
    public suspend fun sendToSubscriptionAdministrator(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendToSubscriptionAdministrator = mapped
    }

    /**
     * @param value a value indicating whether to send email to subscription co-administrators.
     */
    @JvmName("wimtcqnlehordaip")
    public suspend fun sendToSubscriptionCoAdministrators(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendToSubscriptionCoAdministrators = mapped
    }

    internal fun build(): EmailNotificationArgs = EmailNotificationArgs(
        customEmails = customEmails,
        sendToSubscriptionAdministrator = sendToSubscriptionAdministrator,
        sendToSubscriptionCoAdministrators = sendToSubscriptionCoAdministrators,
    )
}
