@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetExportConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property exportId The Continuous Export configuration ID. This is unique within a Application Insights component.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 */
public data class GetExportConfigurationPlainArgs(
    public val exportId: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetExportConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetExportConfigurationPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetExportConfigurationPlainArgs.builder()
            .exportId(exportId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExportConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetExportConfigurationPlainArgsBuilder internal constructor() {
    private var exportId: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The Continuous Export configuration ID. This is unique within a Application Insights component.
     */
    @JvmName("bssgiqyvlmahjypt")
    public suspend fun exportId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.exportId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gvvyemsubndrwvuo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("hyjyfovpxthskuyc")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetExportConfigurationPlainArgs = GetExportConfigurationPlainArgs(
        exportId = exportId ?: throw PulumiNullFieldException("exportId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
