@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetFavoritePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property favoriteId The Id of a specific favorite defined in the Application Insights component
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 */
public data class GetFavoritePlainArgs(
    public val favoriteId: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetFavoritePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetFavoritePlainArgs =
        com.pulumi.azurenative.insights.inputs.GetFavoritePlainArgs.builder()
            .favoriteId(favoriteId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFavoritePlainArgs].
 */
@PulumiTagMarker
public class GetFavoritePlainArgsBuilder internal constructor() {
    private var favoriteId: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The Id of a specific favorite defined in the Application Insights component
     */
    @JvmName("oyukdtmkvgixsnkm")
    public suspend fun favoriteId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.favoriteId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lyquvsulhqelwgkh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("hagygydlswcvoytc")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetFavoritePlainArgs = GetFavoritePlainArgs(
        favoriteId = favoriteId ?: throw PulumiNullFieldException("favoriteId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
