@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetManagementGroupDiagnosticSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupId The management group id.
 * @property name The name of the diagnostic setting.
 */
public data class GetManagementGroupDiagnosticSettingPlainArgs(
    public val managementGroupId: String,
    public val name: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetManagementGroupDiagnosticSettingPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.GetManagementGroupDiagnosticSettingPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetManagementGroupDiagnosticSettingPlainArgs.builder()
            .managementGroupId(managementGroupId.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementGroupDiagnosticSettingPlainArgs].
 */
@PulumiTagMarker
public class GetManagementGroupDiagnosticSettingPlainArgsBuilder internal constructor() {
    private var managementGroupId: String? = null

    private var name: String? = null

    /**
     * @param value The management group id.
     */
    @JvmName("iydqbqbrdgeotush")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("sxnkfrjlpyapqnho")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetManagementGroupDiagnosticSettingPlainArgs =
        GetManagementGroupDiagnosticSettingPlainArgs(
            managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
