@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetMetricAlertPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleName The name of the rule.
 */
public data class GetMetricAlertPlainArgs(
    public val resourceGroupName: String,
    public val ruleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetMetricAlertPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetMetricAlertPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetMetricAlertPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleName(ruleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMetricAlertPlainArgs].
 */
@PulumiTagMarker
public class GetMetricAlertPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var ruleName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sbgbfrlicskokhsf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("jehqfnohgnwsnfls")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleName = mapped
    }

    internal fun build(): GetMetricAlertPlainArgs = GetMetricAlertPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
    )
}
