@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.HeaderFieldArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A header to add to the WebTest.
 * @property headerFieldName The name of the header.
 * @property headerFieldValue The value of the header.
 */
public data class HeaderFieldArgs(
    public val headerFieldName: Output<String>? = null,
    public val headerFieldValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.HeaderFieldArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.HeaderFieldArgs =
        com.pulumi.azurenative.insights.inputs.HeaderFieldArgs.builder()
            .headerFieldName(headerFieldName?.applyValue({ args0 -> args0 }))
            .headerFieldValue(headerFieldValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HeaderFieldArgs].
 */
@PulumiTagMarker
public class HeaderFieldArgsBuilder internal constructor() {
    private var headerFieldName: Output<String>? = null

    private var headerFieldValue: Output<String>? = null

    /**
     * @param value The name of the header.
     */
    @JvmName("onmfpohttoyakyln")
    public suspend fun headerFieldName(`value`: Output<String>) {
        this.headerFieldName = value
    }

    /**
     * @param value The value of the header.
     */
    @JvmName("kmqyrkwemjmqiurt")
    public suspend fun headerFieldValue(`value`: Output<String>) {
        this.headerFieldValue = value
    }

    /**
     * @param value The name of the header.
     */
    @JvmName("xtewbfprmlgmpbtj")
    public suspend fun headerFieldName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerFieldName = mapped
    }

    /**
     * @param value The value of the header.
     */
    @JvmName("ykenagohssdlednb")
    public suspend fun headerFieldValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerFieldValue = mapped
    }

    internal fun build(): HeaderFieldArgs = HeaderFieldArgs(
        headerFieldName = headerFieldName,
        headerFieldValue = headerFieldValue,
    )
}
