@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.LogFileSettingsTextArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownLogFileTextSettingsRecordStartTimestampFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Text settings
 * @property recordStartTimestampFormat One of the supported timestamp formats
 */
public data class LogFileSettingsTextArgs(
    public val recordStartTimestampFormat:
    Output<Either<String, KnownLogFileTextSettingsRecordStartTimestampFormat>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.LogFileSettingsTextArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.LogFileSettingsTextArgs =
        com.pulumi.azurenative.insights.inputs.LogFileSettingsTextArgs.builder()
            .recordStartTimestampFormat(
                recordStartTimestampFormat.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [LogFileSettingsTextArgs].
 */
@PulumiTagMarker
public class LogFileSettingsTextArgsBuilder internal constructor() {
    private var recordStartTimestampFormat:
        Output<Either<String, KnownLogFileTextSettingsRecordStartTimestampFormat>>? = null

    /**
     * @param value One of the supported timestamp formats
     */
    @JvmName("fjkwmdyvmgloommu")
    public suspend
    fun recordStartTimestampFormat(`value`: Output<Either<String, KnownLogFileTextSettingsRecordStartTimestampFormat>>) {
        this.recordStartTimestampFormat = value
    }

    /**
     * @param value One of the supported timestamp formats
     */
    @JvmName("oggageufdvjjvvhc")
    public suspend
    fun recordStartTimestampFormat(`value`: Either<String, KnownLogFileTextSettingsRecordStartTimestampFormat>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordStartTimestampFormat = mapped
    }

    /**
     * @param value One of the supported timestamp formats
     */
    @JvmName("xyrenklnfkktsatj")
    public fun recordStartTimestampFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String,
            KnownLogFileTextSettingsRecordStartTimestampFormat,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordStartTimestampFormat = mapped
    }

    /**
     * @param value One of the supported timestamp formats
     */
    @JvmName("mlglfijvubjhuffg")
    public
    fun recordStartTimestampFormat(`value`: KnownLogFileTextSettingsRecordStartTimestampFormat) {
        val toBeMapped = Either.ofRight<String,
            KnownLogFileTextSettingsRecordStartTimestampFormat,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordStartTimestampFormat = mapped
    }

    internal fun build(): LogFileSettingsTextArgs = LogFileSettingsTextArgs(
        recordStartTimestampFormat = recordStartTimestampFormat ?: throw
            PulumiNullFieldException("recordStartTimestampFormat"),
    )
}
