@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.LogFilesDataSourceArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownLogFilesDataSourceFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Definition of which custom log files will be collected by this data collection rule
 * @property filePatterns File Patterns where the log files are located
 * @property format The data format of the log files
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property settings The log files specific settings.
 * @property streams List of streams that this data source will be sent to.
 * A stream indicates what schema will be used for this data source
 */
public data class LogFilesDataSourceArgs(
    public val filePatterns: Output<List<String>>,
    public val format: Output<Either<String, KnownLogFilesDataSourceFormat>>,
    public val name: Output<String>? = null,
    public val settings: Output<LogFilesDataSourceSettingsArgs>? = null,
    public val streams: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.LogFilesDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.LogFilesDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.LogFilesDataSourceArgs.builder()
            .filePatterns(filePatterns.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .format(
                format.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .streams(streams.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [LogFilesDataSourceArgs].
 */
@PulumiTagMarker
public class LogFilesDataSourceArgsBuilder internal constructor() {
    private var filePatterns: Output<List<String>>? = null

    private var format: Output<Either<String, KnownLogFilesDataSourceFormat>>? = null

    private var name: Output<String>? = null

    private var settings: Output<LogFilesDataSourceSettingsArgs>? = null

    private var streams: Output<List<String>>? = null

    /**
     * @param value File Patterns where the log files are located
     */
    @JvmName("ksjmpaaxavbwqttp")
    public suspend fun filePatterns(`value`: Output<List<String>>) {
        this.filePatterns = value
    }

    @JvmName("eltkcsikwqltsbsu")
    public suspend fun filePatterns(vararg values: Output<String>) {
        this.filePatterns = Output.all(values.asList())
    }

    /**
     * @param values File Patterns where the log files are located
     */
    @JvmName("yehfglrvyivnthoq")
    public suspend fun filePatterns(values: List<Output<String>>) {
        this.filePatterns = Output.all(values)
    }

    /**
     * @param value The data format of the log files
     */
    @JvmName("iwefobwsdlakcfmr")
    public suspend fun format(`value`: Output<Either<String, KnownLogFilesDataSourceFormat>>) {
        this.format = value
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("bgsqngnvvyfhnfhs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The log files specific settings.
     */
    @JvmName("bwkcrmbmotaovlgs")
    public suspend fun settings(`value`: Output<LogFilesDataSourceSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data source
     */
    @JvmName("mcnmrolxqvxspmqd")
    public suspend fun streams(`value`: Output<List<String>>) {
        this.streams = value
    }

    @JvmName("swhbrayxbtyvpynu")
    public suspend fun streams(vararg values: Output<String>) {
        this.streams = Output.all(values.asList())
    }

    /**
     * @param values List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data source
     */
    @JvmName("vymngikebdoxwbct")
    public suspend fun streams(values: List<Output<String>>) {
        this.streams = Output.all(values)
    }

    /**
     * @param value File Patterns where the log files are located
     */
    @JvmName("xmrbtqikwkwtjqrd")
    public suspend fun filePatterns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filePatterns = mapped
    }

    /**
     * @param values File Patterns where the log files are located
     */
    @JvmName("rktmfhikfjunvhwf")
    public suspend fun filePatterns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filePatterns = mapped
    }

    /**
     * @param value The data format of the log files
     */
    @JvmName("itanxnnfagfxfelh")
    public suspend fun format(`value`: Either<String, KnownLogFilesDataSourceFormat>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The data format of the log files
     */
    @JvmName("srpdwnbkrmmmfurf")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KnownLogFilesDataSourceFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The data format of the log files
     */
    @JvmName("whkaleilkxflayvb")
    public fun format(`value`: KnownLogFilesDataSourceFormat) {
        val toBeMapped = Either.ofRight<String, KnownLogFilesDataSourceFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("txpqfnqqhnkaypvu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The log files specific settings.
     */
    @JvmName("iqbbkfimirofmpbk")
    public suspend fun settings(`value`: LogFilesDataSourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument The log files specific settings.
     */
    @JvmName("lugdqsyheqfxaoxc")
    public suspend fun settings(argument: suspend LogFilesDataSourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LogFilesDataSourceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param value List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data source
     */
    @JvmName("wvrroarpjfbcxdps")
    public suspend fun streams(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param values List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data source
     */
    @JvmName("mbpusvyeaetfhdab")
    public suspend fun streams(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    internal fun build(): LogFilesDataSourceArgs = LogFilesDataSourceArgs(
        filePatterns = filePatterns ?: throw PulumiNullFieldException("filePatterns"),
        format = format ?: throw PulumiNullFieldException("format"),
        name = name,
        settings = settings,
        streams = streams ?: throw PulumiNullFieldException("streams"),
    )
}
