@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ManagementEventAggregationConditionArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.ConditionOperator
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * How the data that is collected should be combined over time.
 * @property operator the condition operator.
 * @property threshold The threshold value that activates the alert.
 * @property windowSize the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
 */
public data class ManagementEventAggregationConditionArgs(
    public val `operator`: Output<ConditionOperator>? = null,
    public val threshold: Output<Double>? = null,
    public val windowSize: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ManagementEventAggregationConditionArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.ManagementEventAggregationConditionArgs =
        com.pulumi.azurenative.insights.inputs.ManagementEventAggregationConditionArgs.builder()
            .`operator`(`operator`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .threshold(threshold?.applyValue({ args0 -> args0 }))
            .windowSize(windowSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementEventAggregationConditionArgs].
 */
@PulumiTagMarker
public class ManagementEventAggregationConditionArgsBuilder internal constructor() {
    private var `operator`: Output<ConditionOperator>? = null

    private var threshold: Output<Double>? = null

    private var windowSize: Output<String>? = null

    /**
     * @param value the condition operator.
     */
    @JvmName("nylqcmofwwhuksdo")
    public suspend fun `operator`(`value`: Output<ConditionOperator>) {
        this.`operator` = value
    }

    /**
     * @param value The threshold value that activates the alert.
     */
    @JvmName("rxscirjyladeevro")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
     */
    @JvmName("xsmgnaymejkbuymv")
    public suspend fun windowSize(`value`: Output<String>) {
        this.windowSize = value
    }

    /**
     * @param value the condition operator.
     */
    @JvmName("hufgubjhpldklcqq")
    public suspend fun `operator`(`value`: ConditionOperator?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The threshold value that activates the alert.
     */
    @JvmName("gmdtmkvbebdbovfr")
    public suspend fun threshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
     */
    @JvmName("enqlyshcyywlxtqb")
    public suspend fun windowSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowSize = mapped
    }

    internal fun build(): ManagementEventAggregationConditionArgs =
        ManagementEventAggregationConditionArgs(
            `operator` = `operator`,
            threshold = threshold,
            windowSize = windowSize,
        )
}
