@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.MetricDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies a metric dimension.
 * @property name Name of the dimension.
 * @property operator the dimension operator. Only 'Include' and 'Exclude' are supported
 * @property values list of dimension values.
 */
public data class MetricDimensionArgs(
    public val name: Output<String>,
    public val `operator`: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.MetricDimensionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.MetricDimensionArgs =
        com.pulumi.azurenative.insights.inputs.MetricDimensionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`operator`(`operator`.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [MetricDimensionArgs].
 */
@PulumiTagMarker
public class MetricDimensionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `operator`: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Name of the dimension.
     */
    @JvmName("blrnqaxtlimydlof")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value the dimension operator. Only 'Include' and 'Exclude' are supported
     */
    @JvmName("xblqhexlqqmgreop")
    public suspend fun `operator`(`value`: Output<String>) {
        this.`operator` = value
    }

    /**
     * @param value list of dimension values.
     */
    @JvmName("eorwldckhwandsky")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("qipmdabyqmqvexil")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values list of dimension values.
     */
    @JvmName("yohcpvgqjkeqbiov")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Name of the dimension.
     */
    @JvmName("ylfbsnyofgcnhpan")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value the dimension operator. Only 'Include' and 'Exclude' are supported
     */
    @JvmName("jbckuwbbliisimsd")
    public suspend fun `operator`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value list of dimension values.
     */
    @JvmName("fpkcyrsllcqmrndr")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values list of dimension values.
     */
    @JvmName("ewsyjojihqdlovok")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): MetricDimensionArgs = MetricDimensionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
