@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.MonitoringAccountDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Monitoring account destination.
 * @property accountResourceId The resource ID of the monitoring account.
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 */
public data class MonitoringAccountDestinationArgs(
    public val accountResourceId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.MonitoringAccountDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.MonitoringAccountDestinationArgs =
        com.pulumi.azurenative.insights.inputs.MonitoringAccountDestinationArgs.builder()
            .accountResourceId(accountResourceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitoringAccountDestinationArgs].
 */
@PulumiTagMarker
public class MonitoringAccountDestinationArgsBuilder internal constructor() {
    private var accountResourceId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The resource ID of the monitoring account.
     */
    @JvmName("iojjtiumgnoaroda")
    public suspend fun accountResourceId(`value`: Output<String>) {
        this.accountResourceId = value
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("sdcjdkdbfwfmehpk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource ID of the monitoring account.
     */
    @JvmName("srnwirmfagswfmhq")
    public suspend fun accountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountResourceId = mapped
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("fgvsaajwxaguqowf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): MonitoringAccountDestinationArgs = MonitoringAccountDestinationArgs(
        accountResourceId = accountResourceId,
        name = name,
    )
}
