@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.PerformanceCounterConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instance
 * @property name
 * @property samplingPeriod
 */
public data class PerformanceCounterConfigurationArgs(
    public val instance: Output<String>? = null,
    public val name: Output<String>,
    public val samplingPeriod: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.PerformanceCounterConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.PerformanceCounterConfigurationArgs =
        com.pulumi.azurenative.insights.inputs.PerformanceCounterConfigurationArgs.builder()
            .instance(instance?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .samplingPeriod(samplingPeriod.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PerformanceCounterConfigurationArgs].
 */
@PulumiTagMarker
public class PerformanceCounterConfigurationArgsBuilder internal constructor() {
    private var instance: Output<String>? = null

    private var name: Output<String>? = null

    private var samplingPeriod: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("qcfxeumygidlwliw")
    public suspend fun instance(`value`: Output<String>) {
        this.instance = value
    }

    /**
     * @param value
     */
    @JvmName("spfivurqxrepaoqj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("vsgofbhnftwayoct")
    public suspend fun samplingPeriod(`value`: Output<String>) {
        this.samplingPeriod = value
    }

    /**
     * @param value
     */
    @JvmName("griyrpxwfiioinxh")
    public suspend fun instance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instance = mapped
    }

    /**
     * @param value
     */
    @JvmName("qfyhhqjpieaarxri")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("ddchyxinapvtikdx")
    public suspend fun samplingPeriod(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingPeriod = mapped
    }

    internal fun build(): PerformanceCounterConfigurationArgs = PerformanceCounterConfigurationArgs(
        instance = instance,
        name = name ?: throw PulumiNullFieldException("name"),
        samplingPeriod = samplingPeriod ?: throw PulumiNullFieldException("samplingPeriod"),
    )
}
