@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.RuleEmailActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction in this case.
 * @property customEmails the list of administrator's custom email addresses to notify of the activation of the alert.
 * @property odataType specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'.
 * @property sendToServiceOwners Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
 */
public data class RuleEmailActionArgs(
    public val customEmails: Output<List<String>>? = null,
    public val odataType: Output<String>,
    public val sendToServiceOwners: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.RuleEmailActionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.RuleEmailActionArgs =
        com.pulumi.azurenative.insights.inputs.RuleEmailActionArgs.builder()
            .customEmails(customEmails?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .sendToServiceOwners(sendToServiceOwners?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleEmailActionArgs].
 */
@PulumiTagMarker
public class RuleEmailActionArgsBuilder internal constructor() {
    private var customEmails: Output<List<String>>? = null

    private var odataType: Output<String>? = null

    private var sendToServiceOwners: Output<Boolean>? = null

    /**
     * @param value the list of administrator's custom email addresses to notify of the activation of the alert.
     */
    @JvmName("tbujersqualtinhs")
    public suspend fun customEmails(`value`: Output<List<String>>) {
        this.customEmails = value
    }

    @JvmName("yijxhqnapqngtwms")
    public suspend fun customEmails(vararg values: Output<String>) {
        this.customEmails = Output.all(values.asList())
    }

    /**
     * @param values the list of administrator's custom email addresses to notify of the activation of the alert.
     */
    @JvmName("bvycqnnerbsdxlpi")
    public suspend fun customEmails(values: List<Output<String>>) {
        this.customEmails = Output.all(values)
    }

    /**
     * @param value specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'.
     */
    @JvmName("vgvmcsxmlsaxgjdh")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
     */
    @JvmName("engnlrmetpxogcnx")
    public suspend fun sendToServiceOwners(`value`: Output<Boolean>) {
        this.sendToServiceOwners = value
    }

    /**
     * @param value the list of administrator's custom email addresses to notify of the activation of the alert.
     */
    @JvmName("uyyveghxlhomrkmt")
    public suspend fun customEmails(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEmails = mapped
    }

    /**
     * @param values the list of administrator's custom email addresses to notify of the activation of the alert.
     */
    @JvmName("ndofvqemshibsjpc")
    public suspend fun customEmails(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customEmails = mapped
    }

    /**
     * @param value specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'.
     */
    @JvmName("gwbxjbmfassnmipt")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
     */
    @JvmName("arlnbnbhmigsjjsq")
    public suspend fun sendToServiceOwners(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendToServiceOwners = mapped
    }

    internal fun build(): RuleEmailActionArgs = RuleEmailActionArgs(
        customEmails = customEmails,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        sendToServiceOwners = sendToServiceOwners,
    )
}
