@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.RuleManagementEventClaimsDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The claims for a rule management event data source.
 * @property emailAddress the email address.
 */
public data class RuleManagementEventClaimsDataSourceArgs(
    public val emailAddress: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.RuleManagementEventClaimsDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.RuleManagementEventClaimsDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.RuleManagementEventClaimsDataSourceArgs.builder()
            .emailAddress(emailAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleManagementEventClaimsDataSourceArgs].
 */
@PulumiTagMarker
public class RuleManagementEventClaimsDataSourceArgsBuilder internal constructor() {
    private var emailAddress: Output<String>? = null

    /**
     * @param value the email address.
     */
    @JvmName("nrypcdhdvbvkmkna")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value the email address.
     */
    @JvmName("cgdubhqnbcbtbudh")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    internal fun build(): RuleManagementEventClaimsDataSourceArgs =
        RuleManagementEventClaimsDataSourceArgs(
            emailAddress = emailAddress,
        )
}
