@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ScaleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A rule that provide the triggers and parameters for the scaling action.
 * @property metricTrigger the trigger that results in a scaling action.
 * @property scaleAction the parameters for the scaling action.
 */
public data class ScaleRuleArgs(
    public val metricTrigger: Output<MetricTriggerArgs>,
    public val scaleAction: Output<ScaleActionArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ScaleRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ScaleRuleArgs =
        com.pulumi.azurenative.insights.inputs.ScaleRuleArgs.builder()
            .metricTrigger(metricTrigger.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scaleAction(scaleAction.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScaleRuleArgs].
 */
@PulumiTagMarker
public class ScaleRuleArgsBuilder internal constructor() {
    private var metricTrigger: Output<MetricTriggerArgs>? = null

    private var scaleAction: Output<ScaleActionArgs>? = null

    /**
     * @param value the trigger that results in a scaling action.
     */
    @JvmName("acaqaimwgvhbombf")
    public suspend fun metricTrigger(`value`: Output<MetricTriggerArgs>) {
        this.metricTrigger = value
    }

    /**
     * @param value the parameters for the scaling action.
     */
    @JvmName("xprsnvaigwgvisxk")
    public suspend fun scaleAction(`value`: Output<ScaleActionArgs>) {
        this.scaleAction = value
    }

    /**
     * @param value the trigger that results in a scaling action.
     */
    @JvmName("hvmuagiyoyayedof")
    public suspend fun metricTrigger(`value`: MetricTriggerArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricTrigger = mapped
    }

    /**
     * @param argument the trigger that results in a scaling action.
     */
    @JvmName("ymninnjwtsyhohvs")
    public suspend fun metricTrigger(argument: suspend MetricTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = MetricTriggerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.metricTrigger = mapped
    }

    /**
     * @param value the parameters for the scaling action.
     */
    @JvmName("tgvexwyfhuddvwsj")
    public suspend fun scaleAction(`value`: ScaleActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleAction = mapped
    }

    /**
     * @param argument the parameters for the scaling action.
     */
    @JvmName("ymioqqooagejihfx")
    public suspend fun scaleAction(argument: suspend ScaleActionArgsBuilder.() -> Unit) {
        val toBeMapped = ScaleActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scaleAction = mapped
    }

    internal fun build(): ScaleRuleArgs = ScaleRuleArgs(
        metricTrigger = metricTrigger ?: throw PulumiNullFieldException("metricTrigger"),
        scaleAction = scaleAction ?: throw PulumiNullFieldException("scaleAction"),
    )
}
