@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ThresholdRuleConditionArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.ConditionOperator
import com.pulumi.azurenative.insights.kotlin.enums.TimeAggregationOperator
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A rule condition based on a metric crossing a threshold.
 * @property dataSource the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
 * @property odataType specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'.
 * @property operator the operator used to compare the data and the threshold.
 * @property threshold the threshold value that activates the alert.
 * @property timeAggregation the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
 * @property windowSize the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
 */
public data class ThresholdRuleConditionArgs(
    public val dataSource:
    Output<Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>>? = null,
    public val odataType: Output<String>,
    public val `operator`: Output<ConditionOperator>,
    public val threshold: Output<Double>,
    public val timeAggregation: Output<TimeAggregationOperator>? = null,
    public val windowSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ThresholdRuleConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ThresholdRuleConditionArgs =
        com.pulumi.azurenative.insights.inputs.ThresholdRuleConditionArgs.builder()
            .dataSource(
                dataSource?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .`operator`(`operator`.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .threshold(threshold.applyValue({ args0 -> args0 }))
            .timeAggregation(timeAggregation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .windowSize(windowSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThresholdRuleConditionArgs].
 */
@PulumiTagMarker
public class ThresholdRuleConditionArgsBuilder internal constructor() {
    private var dataSource:
        Output<Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>>? = null

    private var odataType: Output<String>? = null

    private var `operator`: Output<ConditionOperator>? = null

    private var threshold: Output<Double>? = null

    private var timeAggregation: Output<TimeAggregationOperator>? = null

    private var windowSize: Output<String>? = null

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("clmqkpxnyytkluqj")
    public suspend
    fun dataSource(`value`: Output<Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>>) {
        this.dataSource = value
    }

    /**
     * @param value specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'.
     */
    @JvmName("ejkldfpcrbqufcow")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value the operator used to compare the data and the threshold.
     */
    @JvmName("hshmetsvefoteapw")
    public suspend fun `operator`(`value`: Output<ConditionOperator>) {
        this.`operator` = value
    }

    /**
     * @param value the threshold value that activates the alert.
     */
    @JvmName("oxpeusqdhinybkob")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
     */
    @JvmName("wsfieqbieagqjtxd")
    public suspend fun timeAggregation(`value`: Output<TimeAggregationOperator>) {
        this.timeAggregation = value
    }

    /**
     * @param value the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
     */
    @JvmName("msktsourhcicsyvk")
    public suspend fun windowSize(`value`: Output<String>) {
        this.windowSize = value
    }

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("wvcikieycdedcaik")
    public suspend
    fun dataSource(`value`: Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("gwckwqrtlfaolxyk")
    public fun dataSource(`value`: RuleManagementEventDataSourceArgs) {
        val toBeMapped = Either.ofLeft<RuleManagementEventDataSourceArgs,
            RuleMetricDataSourceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("hlysrlhrmhnoqbgn")
    public fun dataSource(`value`: RuleMetricDataSourceArgs) {
        val toBeMapped = Either.ofRight<RuleManagementEventDataSourceArgs,
            RuleMetricDataSourceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'.
     */
    @JvmName("miojduufkxglcfwb")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value the operator used to compare the data and the threshold.
     */
    @JvmName("mpjmnmstlyiccyhu")
    public suspend fun `operator`(`value`: ConditionOperator) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value the threshold value that activates the alert.
     */
    @JvmName("kccumlrwgyfivbmx")
    public suspend fun threshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
     */
    @JvmName("xndiurvkmjdjjylf")
    public suspend fun timeAggregation(`value`: TimeAggregationOperator?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    /**
     * @param value the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
     */
    @JvmName("sxlpfsslblymyrnq")
    public suspend fun windowSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowSize = mapped
    }

    internal fun build(): ThresholdRuleConditionArgs = ThresholdRuleConditionArgs(
        dataSource = dataSource,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        threshold = threshold ?: throw PulumiNullFieldException("threshold"),
        timeAggregation = timeAggregation,
        windowSize = windowSize,
    )
}
