@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A pointer to an Azure Action Group.
 * @property actionGroupId The resource ID of the Action Group. This cannot be null or empty.
 * @property webhookProperties the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
 */
public data class ActionGroupResponse(
    public val actionGroupId: String,
    public val webhookProperties: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ActionGroupResponse):
            ActionGroupResponse = ActionGroupResponse(
            actionGroupId = javaType.actionGroupId(),
            webhookProperties = javaType.webhookProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
