@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * An Activity Log Alert rule condition that is met when all its member conditions are met.
 * @property allOf The list of Activity Log Alert rule conditions.
 */
public data class AlertRuleAllOfConditionResponse(
    public val allOf: List<AlertRuleAnyOfOrLeafConditionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.AlertRuleAllOfConditionResponse):
            AlertRuleAllOfConditionResponse = AlertRuleAllOfConditionResponse(
            allOf = javaType.allOf().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.AlertRuleAnyOfOrLeafConditionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
