@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A condition of the scheduled query rule.
 * @property dimensions List of Dimensions conditions
 * @property failingPeriods The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
 * @property metricMeasureColumn The column containing the metric measure number. Relevant only for rules of the kind LogAlert.
 * @property metricName The name of the metric to be sent. Relevant and required only for rules of the kind LogToMetric.
 * @property operator The criteria operator. Relevant and required only for rules of the kind LogAlert.
 * @property query Log query alert
 * @property resourceIdColumn The column containing the resource id. The content of the column must be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
 * @property threshold the criteria threshold value that activates the alert. Relevant and required only for rules of the kind LogAlert.
 * @property timeAggregation Aggregation type. Relevant and required only for rules of the kind LogAlert.
 */
public data class ConditionResponse(
    public val dimensions: List<DimensionResponse>? = null,
    public val failingPeriods: ConditionResponseFailingPeriods? = null,
    public val metricMeasureColumn: String? = null,
    public val metricName: String? = null,
    public val `operator`: String? = null,
    public val query: String? = null,
    public val resourceIdColumn: String? = null,
    public val threshold: Double? = null,
    public val timeAggregation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ConditionResponse):
            ConditionResponse = ConditionResponse(
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DimensionResponse.Companion.toKotlin(args0)
                })
            }),
            failingPeriods = javaType.failingPeriods().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ConditionResponseFailingPeriods.Companion.toKotlin(args0)
                })
            }).orElse(null),
            metricMeasureColumn = javaType.metricMeasureColumn().map({ args0 -> args0 }).orElse(null),
            metricName = javaType.metricName().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`().map({ args0 -> args0 }).orElse(null),
            query = javaType.query().map({ args0 -> args0 }).orElse(null),
            resourceIdColumn = javaType.resourceIdColumn().map({ args0 -> args0 }).orElse(null),
            threshold = javaType.threshold().map({ args0 -> args0 }).orElse(null),
            timeAggregation = javaType.timeAggregation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
