@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The specification of data sources.
 * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
 * @property dataImports Specifications of pull based data sources
 * @property extensions The list of Azure VM extension data source configurations.
 * @property iisLogs The list of IIS logs source configurations.
 * @property logFiles The list of Log files source configurations.
 * @property performanceCounters The list of performance counter data source configurations.
 * @property platformTelemetry The list of platform telemetry configurations
 * @property prometheusForwarder The list of Prometheus forwarder data source configurations.
 * @property syslog The list of Syslog data source configurations.
 * @property windowsEventLogs The list of Windows Event Log data source configurations.
 * @property windowsFirewallLogs The list of Windows Firewall logs source configurations.
 */
public data class DataCollectionRuleResponseDataSources(
    public val dataImports: DataSourcesSpecResponseDataImports? = null,
    public val extensions: List<ExtensionDataSourceResponse>? = null,
    public val iisLogs: List<IisLogsDataSourceResponse>? = null,
    public val logFiles: List<LogFilesDataSourceResponse>? = null,
    public val performanceCounters: List<PerfCounterDataSourceResponse>? = null,
    public val platformTelemetry: List<PlatformTelemetryDataSourceResponse>? = null,
    public val prometheusForwarder: List<PrometheusForwarderDataSourceResponse>? = null,
    public val syslog: List<SyslogDataSourceResponse>? = null,
    public val windowsEventLogs: List<WindowsEventLogDataSourceResponse>? = null,
    public val windowsFirewallLogs: List<WindowsFirewallLogsDataSourceResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DataCollectionRuleResponseDataSources):
            DataCollectionRuleResponseDataSources = DataCollectionRuleResponseDataSources(
            dataImports = javaType.dataImports().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataSourcesSpecResponseDataImports.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extensions = javaType.extensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ExtensionDataSourceResponse.Companion.toKotlin(args0)
                })
            }),
            iisLogs = javaType.iisLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.IisLogsDataSourceResponse.Companion.toKotlin(args0)
                })
            }),
            logFiles = javaType.logFiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.LogFilesDataSourceResponse.Companion.toKotlin(args0)
                })
            }),
            performanceCounters = javaType.performanceCounters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.PerfCounterDataSourceResponse.Companion.toKotlin(args0)
                })
            }),
            platformTelemetry = javaType.platformTelemetry().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.PlatformTelemetryDataSourceResponse.Companion.toKotlin(args0)
                })
            }),
            prometheusForwarder = javaType.prometheusForwarder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.PrometheusForwarderDataSourceResponse.Companion.toKotlin(args0)
                })
            }),
            syslog = javaType.syslog().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.SyslogDataSourceResponse.Companion.toKotlin(args0)
                })
            }),
            windowsEventLogs = javaType.windowsEventLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WindowsEventLogDataSourceResponse.Companion.toKotlin(args0)
                })
            }),
            windowsFirewallLogs = javaType.windowsFirewallLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WindowsFirewallLogsDataSourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
