@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Data source object contains configuration to collect telemetry and one or more sinks to send that telemetry data to
 * @property configuration
 * @property kind Datasource kind
 * @property sinks
 */
public data class DataSourceResponse(
    public val configuration: DataSourceConfigurationResponse,
    public val kind: String,
    public val sinks: List<SinkConfigurationResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DataSourceResponse):
            DataSourceResponse = DataSourceResponse(
            configuration = javaType.configuration().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.DataSourceConfigurationResponse.Companion.toKotlin(args0)
            }),
            kind = javaType.kind(),
            sinks = javaType.sinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.SinkConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
