@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Monitor Metrics destination.
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 */
public data class DestinationsSpecResponseAzureMonitorMetrics(
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DestinationsSpecResponseAzureMonitorMetrics):
            DestinationsSpecResponseAzureMonitorMetrics = DestinationsSpecResponseAzureMonitorMetrics(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
