@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
 * Collected from either Windows and Linux machines, depending on which extension is defined.
 * @property extensionName The name of the VM extension.
 * @property extensionSettings The extension settings. The format is specific for particular extension.
 * @property inputDataSources The list of data sources this extension needs data from.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams List of streams that this data source will be sent to.
 * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
 */
public data class ExtensionDataSourceResponse(
    public val extensionName: String,
    public val extensionSettings: Any? = null,
    public val inputDataSources: List<String>? = null,
    public val name: String? = null,
    public val streams: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ExtensionDataSourceResponse):
            ExtensionDataSourceResponse = ExtensionDataSourceResponse(
            extensionName = javaType.extensionName(),
            extensionSettings = javaType.extensionSettings().map({ args0 -> args0 }).orElse(null),
            inputDataSources = javaType.inputDataSources().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            streams = javaType.streams().map({ args0 -> args0 }),
        )
    }
}
