@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An Application Insights component billing features
 * @property currentBillingFeatures Current enabled pricing plan. When the component is in the Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
 * @property dataVolumeCap An Application Insights component daily data volume cap
 */
public data class GetComponentCurrentBillingFeatureResult(
    public val currentBillingFeatures: List<String>? = null,
    public val dataVolumeCap: ApplicationInsightsComponentDataVolumeCapResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetComponentCurrentBillingFeatureResult):
            GetComponentCurrentBillingFeatureResult = GetComponentCurrentBillingFeatureResult(
            currentBillingFeatures = javaType.currentBillingFeatures().map({ args0 -> args0 }),
            dataVolumeCap = javaType.dataVolumeCap().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ApplicationInsightsComponentDataVolumeCapResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
