@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Application Insights component linked storage accounts
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property linkedStorageAccount Linked storage account resource ID
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetComponentLinkedStorageAccountResult(
    public val id: String,
    public val linkedStorageAccount: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetComponentLinkedStorageAccountResult):
            GetComponentLinkedStorageAccountResult = GetComponentLinkedStorageAccountResult(
            id = javaType.id(),
            linkedStorageAccount = javaType.linkedStorageAccount().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
