@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties that define a Continuous Export configuration.
 * @property applicationName The name of the Application Insights component.
 * @property containerName The name of the destination storage container.
 * @property destinationAccountId The name of destination account.
 * @property destinationStorageLocationId The destination account location ID.
 * @property destinationStorageSubscriptionId The destination storage account subscription ID.
 * @property destinationType The destination type.
 * @property exportId The unique ID of the export configuration inside an Application Insights component. It is auto generated when the Continuous Export configuration is created.
 * @property exportStatus This indicates current Continuous Export configuration status. The possible values are 'Preparing', 'Success', 'Failure'.
 * @property instrumentationKey The instrumentation key of the Application Insights component.
 * @property isUserEnabled This will be 'true' if the Continuous Export configuration is enabled, otherwise it will be 'false'.
 * @property lastGapTime The last time the Continuous Export configuration started failing.
 * @property lastSuccessTime The last time data was successfully delivered to the destination storage container for this Continuous Export configuration.
 * @property lastUserUpdate Last time the Continuous Export configuration was updated.
 * @property notificationQueueEnabled Deprecated
 * @property permanentErrorReason This is the reason the Continuous Export configuration started failing. It can be 'AzureStorageNotFound' or 'AzureStorageAccessDenied'.
 * @property recordTypes This comma separated list of document types that will be exported. The possible values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
 * @property resourceGroup The resource group of the Application Insights component.
 * @property storageName The name of the destination storage account.
 * @property subscriptionId The subscription of the Application Insights component.
 */
public data class GetExportConfigurationResult(
    public val applicationName: String,
    public val containerName: String,
    public val destinationAccountId: String,
    public val destinationStorageLocationId: String,
    public val destinationStorageSubscriptionId: String,
    public val destinationType: String,
    public val exportId: String,
    public val exportStatus: String,
    public val instrumentationKey: String,
    public val isUserEnabled: String,
    public val lastGapTime: String,
    public val lastSuccessTime: String,
    public val lastUserUpdate: String,
    public val notificationQueueEnabled: String? = null,
    public val permanentErrorReason: String,
    public val recordTypes: String? = null,
    public val resourceGroup: String,
    public val storageName: String,
    public val subscriptionId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetExportConfigurationResult):
            GetExportConfigurationResult = GetExportConfigurationResult(
            applicationName = javaType.applicationName(),
            containerName = javaType.containerName(),
            destinationAccountId = javaType.destinationAccountId(),
            destinationStorageLocationId = javaType.destinationStorageLocationId(),
            destinationStorageSubscriptionId = javaType.destinationStorageSubscriptionId(),
            destinationType = javaType.destinationType(),
            exportId = javaType.exportId(),
            exportStatus = javaType.exportStatus(),
            instrumentationKey = javaType.instrumentationKey(),
            isUserEnabled = javaType.isUserEnabled(),
            lastGapTime = javaType.lastGapTime(),
            lastSuccessTime = javaType.lastSuccessTime(),
            lastUserUpdate = javaType.lastUserUpdate(),
            notificationQueueEnabled = javaType.notificationQueueEnabled().map({ args0 -> args0 }).orElse(null),
            permanentErrorReason = javaType.permanentErrorReason(),
            recordTypes = javaType.recordTypes().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup(),
            storageName = javaType.storageName(),
            subscriptionId = javaType.subscriptionId(),
        )
    }
}
