@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The management group diagnostic setting resource.
 * @property eventHubAuthorizationRuleId The resource Id for the event hub authorization rule.
 * @property eventHubName The name of the event hub. If none is specified, the default event hub will be selected.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property logs The list of logs settings.
 * @property marketplacePartnerId The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
 * @property name The name of the resource
 * @property serviceBusRuleId The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
 * @property storageAccountId The resource ID of the storage account to which you would like to send Diagnostic Logs.
 * @property systemData The system metadata related to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property workspaceId The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
 */
public data class GetManagementGroupDiagnosticSettingResult(
    public val eventHubAuthorizationRuleId: String? = null,
    public val eventHubName: String? = null,
    public val id: String,
    public val logs: List<ManagementGroupLogSettingsResponse>? = null,
    public val marketplacePartnerId: String? = null,
    public val name: String,
    public val serviceBusRuleId: String? = null,
    public val storageAccountId: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val workspaceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetManagementGroupDiagnosticSettingResult):
            GetManagementGroupDiagnosticSettingResult = GetManagementGroupDiagnosticSettingResult(
            eventHubAuthorizationRuleId = javaType.eventHubAuthorizationRuleId().map({ args0 ->
                args0
            }).orElse(null),
            eventHubName = javaType.eventHubName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            logs = javaType.logs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ManagementGroupLogSettingsResponse.Companion.toKotlin(args0)
                })
            }),
            marketplacePartnerId = javaType.marketplacePartnerId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            serviceBusRuleId = javaType.serviceBusRuleId().map({ args0 -> args0 }).orElse(null),
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            workspaceId = javaType.workspaceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
