@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An Application Insights private workbook definition.
 * @property category Workbook category, as defined by the user at creation time.
 * @property displayName The user-defined name of the private workbook.
 * @property etag Resource etag
 * @property id Azure resource Id
 * @property identity Identity used for BYOS
 * @property kind The kind of workbook. Choices are user and shared.
 * @property location Resource location
 * @property name Azure resource name
 * @property serializedData Configuration of this particular private workbook. Configuration data is a string containing valid JSON
 * @property sourceId Optional resourceId for a source resource.
 * @property storageUri BYOS Storage Account URI
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags
 * @property timeModified Date and time in UTC of the last modification that was made to this private workbook definition.
 * @property type Azure resource type
 * @property userId Unique user id of the specific user that owns this private workbook.
 * @property version This instance's version of the data model. This can change as new features are added that can be marked private workbook.
 */
public data class GetMyWorkbookResult(
    public val category: String,
    public val displayName: String,
    public val etag: Map<String, String>? = null,
    public val id: String? = null,
    public val identity: MyWorkbookManagedIdentityResponse? = null,
    public val kind: String? = null,
    public val location: String? = null,
    public val name: String? = null,
    public val serializedData: String,
    public val sourceId: String? = null,
    public val storageUri: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val timeModified: String,
    public val type: String? = null,
    public val userId: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetMyWorkbookResult):
            GetMyWorkbookResult = GetMyWorkbookResult(
            category = javaType.category(),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.MyWorkbookManagedIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            serializedData = javaType.serializedData(),
            sourceId = javaType.sourceId().map({ args0 -> args0 }).orElse(null),
            storageUri = javaType.storageUri().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeModified = javaType.timeModified(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userId = javaType.userId(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
