@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The parameters for enabling predictive autoscale.
 * @property scaleLookAheadTime the amount of time to specify by which instances are launched in advance. It must be between 1 minute and 60 minutes in ISO 8601 format.
 * @property scaleMode the predictive autoscale mode
 */
public data class PredictiveAutoscalePolicyResponse(
    public val scaleLookAheadTime: String? = null,
    public val scaleMode: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.PredictiveAutoscalePolicyResponse):
            PredictiveAutoscalePolicyResponse = PredictiveAutoscalePolicyResponse(
            scaleLookAheadTime = javaType.scaleLookAheadTime().map({ args0 -> args0 }).orElse(null),
            scaleMode = javaType.scaleMode(),
        )
    }
}
