@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Any
import kotlin.Suppress
import kotlin.collections.List

/**
 * Localized template data and gallery information.
 * @property galleries Workbook galleries supported by the template.
 * @property templateData Valid JSON object containing workbook template payload.
 */
public data class WorkbookTemplateLocalizedGalleryResponse(
    public val galleries: List<WorkbookTemplateGalleryResponse>? = null,
    public val templateData: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WorkbookTemplateLocalizedGalleryResponse):
            WorkbookTemplateLocalizedGalleryResponse = WorkbookTemplateLocalizedGalleryResponse(
            galleries = javaType.galleries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WorkbookTemplateGalleryResponse.Companion.toKotlin(args0)
                })
            }),
            templateData = javaType.templateData().map({ args0 -> args0 }).orElse(null),
        )
    }
}
